package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.*;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.dto.response.GetLogisticsBankResp;
import com.blt.other.module.cost.dto.response.GetLogisticsCodeResp;
import com.blt.other.module.cost.service.CostTypeKindService;
import com.blt.other.module.cost.service.CostTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
@Api(tags = "类型接口")
@RestController
@RequestMapping("/cost/type")
public class CostTypeController {
    @Resource
    private CostTypeKindService costTypeKindService;
    @Resource
    private CostTypeService costTypeService;

    @ApiOperation("分页获取费用类型")
    @PostMapping("/queryPage")
    public CostResult<Page<CostTypeResult>> queryPage(@RequestBody CostTypeQueryPageReq req) {
        log.info("分页获取费用类型");
        Page<CostTypeResult> page = costTypeService.queryPage(req);
        return CostResult.success(page);
    }

    @ApiOperation("获取费用类型详情")
    @PostMapping("/queryDetail")
    public CostResult<CostTypeResult> queryDetail(@RequestParam Integer id) {
        CostTypeResult result = costTypeService.queryDetail(id);
        return CostResult.success(result);
    }

    @ApiOperation("根据编码获取费用类型详情")
    @PostMapping("/queryByNo")
    public CostResult<CostTypeResult> queryByNo(@RequestParam String typeNo) {
        CostTypeResult result = costTypeService.queryByNo(typeNo);
        return CostResult.success(result);
    }

    @ApiOperation("删除费用类型详情")
    @PostMapping("/deleteById")
    public CostResult<Void> deleteById(@RequestParam Integer id) {
        costTypeService.deleteById(id);
        return CostResult.success();
    }


    @ApiOperation("添加费用类型")
    @PostMapping("/addCostType")
    public CostResult<Void> addCostType(@RequestBody CostTypeAddReq req) {
        log.info("添加费用类型");
        costTypeService.addCostType(req);
        return CostResult.success();
    }

    @ApiOperation("更新费用类型（费用类型 或者 会计科目类型）")
    @PostMapping("/modifyCostType")
    public CostResult<Void> modifyCostType(@RequestBody CostTypeModifyReq req) {
        log.info("更新费用类型（费用类型 或者 会计科目类型）");
        costTypeService.modifyCostType(req);
        return CostResult.success();
    }

    @ApiOperation("获取物流subjectCode")
    @GetMapping("/getLogisticsCode")
    public GetLogisticsCodeResp getLogisticsCode() {
        log.info("获取物流subjectCode");
        return costTypeService.getLogisticsCode();
    }

    @ApiOperation("获取物流银行帐号")
    @PostMapping("/getLogisticsBank")
    public GetLogisticsBankResp getLogisticsBank(@RequestParam String subSupplierName) {
        return costTypeService.getLogisticsBank(subSupplierName);
    }

    @ApiOperation("批量导入数据")
    @PostMapping("/importExcel")
    public CostResult<Void> importExcel(CostTypeImportExcelReq excel) throws IOException {
        costTypeService.importExcel(excel);
        return CostResult.success();
    }

    @ApiOperation("导出excel")
    @PostMapping("/exportExcel")
    public CostResult<Void> exportExcel(HttpServletResponse response,
                                        @RequestBody CostTypeExportExcelReq req) throws IOException {
        costTypeService.exportExcel(response, req);
        return CostResult.success();
    }
}
