package com.blt.other.module.purchasing.dao;

import com.blt.other.database.model.PlanSkuTempDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface PlanSkuTempDao {

    /**
     * 插入采购计划商品
     * @param planSkuTempDomain
     * @return
     */
    Integer insertPlanSkuTemp(PlanSkuTempDomain planSkuTempDomain);

    /**
     * 根据 no 和 skucode 查询是否有同一采购单下相同的 sku 存在
     * @param planSkuTempDomain
     * @return
     */
    PlanSkuTempDomain selectByNoAndSkucode(PlanSkuTempDomain planSkuTempDomain);

    /**
     * 修改
     * @param planSkuTempDomain
     * @return
     */
    Integer updatePlanSkuTemp(PlanSkuTempDomain planSkuTempDomain);

    /**
     * 获取采购计划的商品列表
     * @param no
     * @return
     */
    List<PlanSkuTempDomain> selectListByNo(String no);

    Integer deleteByNo(String no);

    void delete(@Param("no") String no, @Param("skucode") String skucode);
}
