package com.blt.other.other_sku.service.impl;

import com.blt.other.other_database.model.SkuKindDomain;
import com.blt.other.other_sku.dao.SkuKindDao;
import com.blt.other.other_sku.service.SkuKindService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service
public class SkuKindServiceImpl implements SkuKindService {

    @Autowired
    private SkuKindDao skuKindDao;

    /**
     * 保存 sku 小类
     * @param skuKindDomain
     * @return
     */
    @Override
    public Integer saveSkuKind(SkuKindDomain skuKindDomain) {
        skuKindDomain.setSkuKindNo(createSkuKindNo());
        Integer insert = skuKindDao.insert(skuKindDomain);
        return insert;
    }

    /**
     * 根据 skuKindNo 获取 sku  小类
     * @param skuKindNo
     * @return
     */
    @Override
    public SkuKindDomain getBySkuKindNo(String skuKindNo) {
        return skuKindDao.selectBySkuKindNo(skuKindNo);
    }

    /**
     * 根据 skuName 和 skuTypeNo 获取存在的 sku 小类
     * @param skuKindName
     * @param skuTypeNo
     * @return
     */
    @Override
    public List<SkuKindDomain> getListBySkuKindNameAndSkuTypeNo(String skuKindName, String skuTypeNo) {
        SkuKindDomain skuKindDomain = new SkuKindDomain();
        skuKindDomain.setSkuTypeNo(skuTypeNo);
        skuKindDomain.setSkuKindName(skuKindName);
        return skuKindDao.selectBySkuKindNameAndSkuTypeNo(skuKindDomain);
    }

    @Override
    public List<SkuKindDomain> getSkuKindList() {
        List<SkuKindDomain> skuKindDomains =  skuKindDao.selectAll();
        return skuKindDomains;
    }

    /**
     * 根据 skuTypeNo 获取 sku 小类
     * @param skuTypeNo
     * @return
     */
    @Override
    public List<SkuKindDomain> getSkuKindListByTypeNo(String skuTypeNo) {
        List<SkuKindDomain> skuKindDomains = skuKindDao.selectBySkuTypeNo(skuTypeNo);
        return skuKindDomains;
    }

    /**
     * 生成唯一编号
     * @return
     */
    private String createSkuKindNo(){
        String skuKindNo = null;
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        skuKindNo = "SKN"+sdf.format(new Date())+random.nextInt(9);
        SkuKindDomain skuKindDomain = skuKindDao.selectBySkuKindNo(skuKindNo);
        while (null != skuKindDomain && null != skuKindDomain.getSkuKindNo()){
            skuKindNo = "SKN"+sdf.format(new Date())+random.nextInt(9);
            skuKindDomain = skuKindDao.selectBySkuKindNo(skuKindNo);
        }
        return skuKindNo;
    }
}
