package com.blt.other.other_purchasing.service.impl;

import com.blt.other.other_database.model.BuyPlanDomain;
import com.blt.other.other_purchasing.dao.BuyPlanSearchDao;
import com.blt.other.other_purchasing.dto.BuyPlanDto;
import com.blt.other.other_purchasing.service.BuyPlanSearchService;
import com.blt.other.other_purchasing.service.BuyPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BuyPlanSearchServiceImpl implements BuyPlanSearchService {

    @Autowired
    private BuyPlanSearchDao buyPlanSearchDao;
    @Autowired
    private BuyPlanService buyPlanService;

    @Override
    public List<BuyPlanDto> searchByKey(String key) {
        List<BuyPlanDomain> buyPlanDomains = buyPlanSearchDao.selectByKey(key);
        List<BuyPlanDto> dtoList = buyPlanService.getDtoList(buyPlanDomains);
        return dtoList;
    }
}
