package com.blt.other.module.cost.service.impl;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.dao.CostLogDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostApiService;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.CostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Rollback;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/2/27 6:24 下午
 */
@Transactional
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("test")
public class CostApiServiceImplTest {

    @Resource
    CostApiService costApiService;

    @Autowired
    CostLogService costLogService;

    @Resource
    CostLogDao costLogDao;

    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;

    @Resource
    private CostService costService;

    @Resource
    CostTypeDao costTypeDao;

    @Test
    public void getCostList() {
        costApiService.getCostList("2021-01-01 00:00:00", "2021-01-01 00:00:00", 1, 10);
    }

    @Test
    public void autoPass() {
        boolean result = false;
        String costNo = "F055624";
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        CostLogDomain costLogDomain = costLogDao.selectDepartmentCheckLog(costDomain.getCostNo());
        List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
        if (costLogDomain != null
                && costCurrentReviewerList
                .stream()
                .map(CostCurrentReviewer::getOaUserId)
                .collect(Collectors.toList())
                .contains(costLogDomain.getUpdateUserid())) {
            //部门审核人和总经办审核人是同一个人，总经办审核人自动通过。
            result = true;
        }
        if (costDomain.getCostForm().equals(2)) {
            //收款不需要审核
            result = true;
        }
        if (costDomain.getProjectType() != null && costDomain.getProjectType().equalsIgnoreCase("DSP")) {
            //DSP不需要审核
            result = true;
        }
        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(costDomain.getTypeNo());
        if (costTypeDomain.getTypeName().contains("工资") || costTypeDomain.getTypeName().contains("物流")
                || costTypeDomain.getTypeName().contains("社保费")
                || costTypeDomain.getTypeName().contains("公积金")
                || costTypeDomain.getTypeName().contains("租金物业水电费")
                || costTypeDomain.getTypeName().contains("车辆使用费")) {
            result = true;
        }

        //小于5k不需要总经办审批，特殊情况除外；
        if (costDomain.getAmountRmb().compareTo(new BigDecimal("5000")) < 0) {
            result = true;
        }

        result = false;


    }

    @Test
    @Rollback(false)
    public void saveByManage() {
        boolean result = false;
        String costNo = "F056019";
        String updateMainNote = "测试日志";
        Integer type = null;
        costLogService.saveByManage(costNo,updateMainNote,type);
    }
}
