package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.dao.CostLogDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.model.ApprovalHistoryDomain;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @Author: li.yanlin
 * @Description： 增加总经办审核，目前限定铭哥审核，超过1w（含）的非工资/物流单，可能只是暂时性，所以先hard code,后续有需求再改
 * @Date: Created in
 * @Modified by:
 */
@Component
@Scope("prototype")
public class GeneralManagerCheckState extends CostState {

    //@Resource
    //UnPayState unPayState;
    @Resource
    FinancialCheckState financialCheckState;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;
    @Resource
    ApprovalHistoryService approvalHistoryService;
    @Resource
    CostTypeDao costTypeDao;
    @Resource
    CostLogDao costLogDao;

    //审批次数
    static Map<LocalDate, Integer> APPROVE_TIMES = new ConcurrentHashMap<>();

    @Override
    public void handle(String reason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        //CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_MANAGER_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }
        //小于5k的自动审核
        if (this.autoPass(costDomain)) {
            costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(costDomain);

            List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
            costLogService.saveByManage(costDomain.getCostNo(), "总经办自动审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                    .collect(Collectors.joining(",")), CostLogDomain.MANAGER_AUTO_PASS);
            //流转状态
            nextState(financialCheckState);
            //发布到总线尝试下个环节的自动审核
            costSubscribe.subscribe(costContext);

            //通知财务系统
            //costContext.costService.toFinancial(costDomain);
            return;

        }
        if (currentUserId != null) {
            //目前限定铭哥能审核或者主体是啫啫煲鹏哥能审核
            if (currentUserId == 681 || ("啫啫煲".equals(costDomain.getCompanyName()) && currentUserId == 720)) {
                //大于等于5需要铭哥审批
                if (costDomain.getAmountRmb().compareTo(new BigDecimal("5000")) >= 0 || ("啫啫煲".equals(costDomain.getCompanyName()) && costDomain.getAmountRmb().compareTo(new BigDecimal("1000")) >= 0)) {
                    costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
                    costDomain.setLastModifyDate(LocalDateTime.now());
                    costDao.updateById(costDomain);

                    List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
                    costLogService.save(costDomain.getCostNo(), currentUserId, "总经办审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                            .collect(Collectors.joining(",")), CostLogDomain.MANAGER_MANUAL_PASS);
                    //流转状态
                    nextState(financialCheckState);
                    //发布到总线尝试下个环节的自动审核
                    costSubscribe.subscribe(costContext);

                    //通知财务系统
                    //costContext.costService.toFinancial(costDomain);
                    return;
                }
            } else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }

    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        //CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_MANAGER_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核拒绝
        if (currentUserId == 681 || currentUserId == 4828 || ("啫啫煲".equals(costDomain.getCompanyName()) && currentUserId == 720)) {
            ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                    .approvalUserId(currentUserId)
                    .approvalTime(LocalDateTime.now())
                    .costStatus(costDomain.getCostStatus())
                    .costNo(costDomain.getCostNo())
                    .isPassed(false)
                    .build();
            approvalHistoryService.save(approvalHistoryDomain);
            costContext.costService.reject(costDomain.getCostNo());
            costLogService.save(costDomain.getCostNo(), currentUserId, "总经办审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);
        } else {
            throw new BizRuntimeException("current user no authority");
        }
    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;

        //只查铭哥的ID,啫啫煲的主体，遇到铭哥审批就换鹏哥 2023-06-01
        OaUser user = oaUserMapper.selectByOaUserId(("啫啫煲".equals(costDomain.getCompanyName())) ? 720 : 681);

        List<CostReviewer> costReviewerList = new ArrayList<>();
        costReviewerList.add(CostReviewer.builder()
                .reviewerUserId(user.getOaUserId())
                .reviewerUserName(user.getUserName())
                .build());
        costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
//        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "最终审核人:" + costReviewerList.stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(",")));

    }

    private boolean autoPass(CostDomain costDomain) {
        CostLogDomain costLogDomain = costLogDao.selectDepartmentCheckLog(costDomain.getCostNo());
        List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
        if (costLogDomain != null
                && costCurrentReviewerList
                .stream()
                .map(CostCurrentReviewer::getOaUserId)
                .collect(Collectors.toList())
                .contains(costLogDomain.getUpdateUserid())) {
            costLogService.saveByManage(costDomain.getCostNo(),"部门审核人和总经办审核人是同一人,符合自动审核条件",null);
            //部门审核人和总经办审核人是同一个人，总经办审核人自动通过。
            return true;
        }
        //付款主体是"啫啫煲"且小于1k不需要总经办审批
        if ("啫啫煲".equals(costDomain.getCompanyName()) && costDomain.getCostForm() != 2) {
            if (costDomain.getAmountRmb().compareTo(new BigDecimal("1000")) < 0) {
                costLogService.saveByManage(costDomain.getCostNo(),"人民币金额【" + costDomain.getAmountRmb() + "】少于设定【1000】审核条件",null);
                return true;
            }
        } else {

            if (costDomain.getCostForm().equals(2)) {
                //收款不需要审核
                return true;
            }
            if (costDomain.getProjectType() != null && costDomain.getProjectType().equalsIgnoreCase("DSP")) {
                costLogService.saveByManage(costDomain.getCostNo(), "项目类型【DSP】符合设定自动审核条件", null);
                //DSP不需要审核
                return true;
            }
            CostTypeDomain costTypeDomain = costTypeDao.selectByNo(costDomain.getTypeNo());
            if (costTypeDomain.getTypeName().contains("工资") || costTypeDomain.getTypeName().contains("物流")
                    || costTypeDomain.getTypeName().contains("社保费")
                    || costTypeDomain.getTypeName().contains("公积金")
                    || costTypeDomain.getTypeName().contains("租金物业水电费")
                    || costTypeDomain.getTypeName().contains("车辆使用费")) {
                costLogService.saveByManage(costDomain.getCostNo(), "费用类型【" + costTypeDomain.getTypeName() + "】符合设定自动审核条件", null);
                return true;
            }

            //小于5k不需要总经办审批，特殊情况除外；
            if (costDomain.getAmountRmb().compareTo(new BigDecimal("5000")) < 0) {
                costLogService.saveByManage(costDomain.getCostNo(), "人民币金额【" + costDomain.getAmountRmb() + "】少于设定【5000】审核条件", null);
                //特殊情况：0(含)-5k(不含)的每天随机抽取三个订单
                //if (costDomain.getAmountRmb().compareTo(new BigDecimal("5000")) >= 0) {
            /* 取消每天随机抽取三个订单的特殊情况
            Integer times = APPROVE_TIMES.get(LocalDate.now());
            if (times == null) {
                APPROVE_TIMES = new ConcurrentHashMap<LocalDate, Integer>() {{
                    put(LocalDate.now(), 1);
                }};
            } else if (times < 3 && LocalDateTime.now().getSecond() % 3 == 0) {
                APPROVE_TIMES.put(LocalDate.now(), ++times);
            } else
            */
                return true;
            /*} else
                return true;*/
            }
        }

        return false;
    }
}
