package com.blt.other.module.cost.service.impl;

import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostListSearchDao;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostListSearchService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.CostListSearchKeysVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class CostListSearchServiceImpl implements CostListSearchService {

    @Autowired
    private CostListSearchDao costListSearchDao;
    @Autowired
    private CostService costService;
    @Autowired
    CostDao costDao;

    @Override
    public CostApiDto.GetByKeyResp searchByKey(String key, int pageNum, int pageSize) {
        CostApiDto.GetByKeyResp resp = new CostApiDto.GetByKeyResp();
        PageHelper.startPage(pageNum, pageSize);
        List<CostDomain> costDomains = costListSearchDao.selectByKey(Lists.newArrayList(key.split(",")).stream().filter(Objects::nonNull).collect(Collectors.toList()));
        costService.setPrimaryDepartment(costDomains);
        List<CostDto> dtos = costDomains.stream().map(CostDomain::castToDto).collect(Collectors.toList());

        PageInfo<CostDomain> pageInfo = new PageInfo<>(costDomains);
        resp.setCosts(dtos);
        resp.setPageInfo(pageInfo);
        resp.setSuccess(true);
        return resp;
    }

    @Override
    public CostApiDto.GetByKeyResp searchByKeys(CostListSearchKeysVo searchKeysVo) {
        CostApiDto.GetByKeyResp resp = new CostApiDto.GetByKeyResp();

        PageHelper.startPage(searchKeysVo.getParams().getPageNum(), searchKeysVo.getParams().getPageSize());
        List<CostDomain> domains = costListSearchDao.selectByKeys(searchKeysVo);
        costService.setPrimaryDepartment(domains);
        PageInfo<CostDomain> pageInfo = new PageInfo<>(domains);
        if (null != searchKeysVo.getParams().getKeys().getLinkCost() && !searchKeysVo.getParams().getKeys().getLinkCost().isEmpty()) {
            List<CostDomain> list = new ArrayList<>();
            CostDomain supCost = costDao.selectByCostNo(searchKeysVo.getParams().getKeys().getLinkCost());
            list.add(supCost);
            if (null != domains && domains.size() >= 1) {
                list.addAll(domains);
            }
            resp.setCosts(list.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
        } else {
            resp.setCosts(domains.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
        }
        resp.setPageInfo(pageInfo);
        resp.setSuccess(true);
        return resp;
    }

    @Override
    public List<CostDomain> getLinkCost() {
        return costListSearchDao.selectLinkList();
    }
}
