package com.blt.other.database.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
@TableName(value = "cost_log")
public class CostLogDomain {
    //更新
    public static final int TYPE_UPDATE = 1;

    public static final int DEPARTMENT_AUTO_PASS = 2;
    public static final int DEPARTMENT_MANUAL_PASS = 3;

    public static final int FINANCIAL_AUTO_PASS = 4;
    public static final int FINANCIAL_MANUAL_PASS = 5;

    public static final int FINAL_AUTO_PASS = 6;
    public static final int FINAL_MANUAL_PASS = 7;

    public static final int HR_PASS = 8;

    public static final int MANAGER_AUTO_PASS = 9;
    public static final int MANAGER_MANUAL_PASS = 10;

    public static final int FACTORY_AUTO_PASS = 10;
    public static final int FACTORY_MANUAL_PASS = 10;

    @TableId(type = IdType.AUTO)
    private Integer id; // 费用单日志

    private String costNo; // 费用单号
    private String updateUsercode; // 更新人编号
    private String updateUsername; // 更新人姓名

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime; // 更新时间
    private String updateNote;
    private Integer updateUserid; // 更新人 ID


    private Integer type;
}
