package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.cost.dto.AddReq;
import com.blt.other.module.cost.dto.CostTemplateBaseColApiReq;
import com.blt.other.module.cost.model.CostTemplateBaseCol;
import com.blt.other.module.cost.model.CostTemplateCol;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * <p>
 * 费用单基础字段 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
public interface ICostTemplateBaseColService extends IService<CostTemplateBaseCol> {

    /**
     * <p>
     * 获取所有费用单基础字段
     * </p>
     *
     * @return 所有费用单基础字段
     */
    List<CostTemplateBaseCol> listAll();

    /**
     * <p>
     * 新增费用单基础字段
     * </p>
     *
     * @param req req
     */
    CostTemplateBaseCol add(AddReq req);

    /**
     * <p>
     * 更新费用单基础字段
     * </p>
     *
     * @param costTemplateBaseCol req
     */
    void modify(CostTemplateBaseCol costTemplateBaseCol);

    /**
     * <p>
     * 删除费用单基础字段
     * </p>
     *
     * @param id id
     */
    void delete(@NonNull Integer id);


    /**
     * <p>
     * 获取不同基础费用单模版对应的默认基础字段
     * </p>
     *
     * @param costType type
     * @return list
     */
    List<CostTemplateBaseCol> defaultBaseColList(@NonNull Integer costType);


    /**
     * <p>
     * 补全聚合
     * </p>
     *
     * @param costTemplateColList req
     */
    void setCostTemplateBaseCol(List<CostTemplateCol> costTemplateColList);

    /**
     * <p>
     * 补全聚合
     * </p>
     *
     * @param costTemplateCol req
     */
    void setCostTemplateBaseCol(CostTemplateCol costTemplateCol);
}
