package com.blt.other.other_cost.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class ManageCostDto {
    @JSONField(name = "detailname")
    private String no; // 费用单号或采购单号
    private String receiveUnit; // 收款单位

    private String receiveBank;
    private String receiveCard;
    private String receiveCardUser;


    private String reason; // 理由/用途
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "cashier_time", format = "yyyy-MM-dd HH:mm:ss")
    private Date payTime; // 付款时间
    private Integer manageCostType; // 费用付款单同cost_form=1，费用借还单同cost_form=3，采购单为0
    private String departmentName; // 部门
    private Integer companyValue; // 公司主体value
    private String companyName; // 付款主体
    private String feeSuperType; // 费用大类
    private String feeSubType; // 费用小类
    @JSONField(name = "cashier_paymoney")
    private BigDecimal amount; // 金额
    @JSONField(name = "cashier_unitcode")
    private String currency; // 币种
    @JSONField(name = "cashier_paymoneyrmb")
    private BigDecimal amountRmb; // 人民币金额
    //费用单Id
    private Integer costId;
    //费用单详情Id
    private Integer costId1;
}
