package com.blt.other.supplier.job;

import com.blt.other.database.model.BuyUserDomain;
import com.blt.other.supplier.service.BuyUserSyncService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.List;

/**
 * 采购员同步
 */
public class BuyUserSyncJob extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(BuyUserSyncJob.class);

    @Autowired
    BuyUserSyncService buyUserSyncService;

    /**
     * 获取用户信息 --> 保存到本系统采购员表
     * @param jobExecutionContext
     * @throws JobExecutionException
     */
    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        List<BuyUserDomain> buyUserAllFromOA = buyUserSyncService.getBuyUserAllFromOA();
        buyUserSyncService.updateToBuyUser(buyUserAllFromOA);
    }
}
