package com.blt.other.database.model;

import com.bailuntec.common.BeanUtils;
import com.bailuntec.cost.api.dto.CostDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CostDomain {

    //付款费用
    public final static Integer COST_FROM_1 = 1;
    //收款费用
    public final static Integer COST_FROM_2 = 2;
    //借支/借还
    public final static Integer COST_FROM_3 = 2;
    // 费用单编号
    private Integer id;
    // 费用单编号
    private String costNo;
    // 费用计划编号
    private String costPlanNo;
    // 主体编号
    private String companyNo;
    // 主体名称
    private String companyName;
    // 类型编号
    private String typeNo;
    // 类型标题
    private String typeName;
    // 科目编号
    private String subjectCode;
    // 小类编号
    private String kindNo;
    // 小类标题
    private String kindName;
    // 创建人 id
    private Integer createUserid;
    // 创建人编号
    private String createUsercode;
    // 创建人名称
    private String createUsername;
    // 费用单备注
    private String costRemark;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    // 创建时间
    private Date createTime;
    // 关联子单
    private String sonCostNo;
    // 关联父单
    private String supCostNo;
    // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private Integer costStatus;
    // 文件地址
    private String filePath;
    // 补充材料地址
    private String morFilePath;
    // 费用总金额
    private BigDecimal amount;
    // 二级物流供应商ID
    private Integer subLogisticsSupplierId;
    // 一级物流供应商ID
    private Integer logisticsSupplierId;
    // 收款银行（平台）
    private String bankName;
    // 收款账户
    private String bankCard;
    // 收款用户名
    private String bankCardUser;
    // 收款/付款单位
    private String bankCompany;
    // 补充信息
    private String morRemark;
    // 1 付款费用 2 收款费用 3 借支/借还
    private Integer costForm;
    // 付款理由
    private String costReason;
    // 1 借支 2 借还
    private Integer isLend;
    // 借支单已还金额
    private BigDecimal hadPay;
    // 借支单状态 1 未还 2 部分还款  3 结清
    private Integer lendStatus;
    // 借支单补偿金额
    private BigDecimal compensate;
    // 冲销金额
    private BigDecimal counteract;
    // 借还单余额
    private BigDecimal lendBalance;
    // 驳回原因
    private String rejectReason;
    // 币种
    private String dic;
    // 借还单冲销金额 ( 支付币种 )
    private BigDecimal payCounteract;
    // 借还单余额 （ 支付币种 ）
    private BigDecimal payLendBalance;
    // 计划金额 （ 支付币种 ）
    private BigDecimal payPlanAmount;
    // 支付币种
    private String payDic;
    // 汇率
    private BigDecimal payCur;
    // 0 不抵扣个税  1 抵扣个税
    private Integer isTax;
    // 出纳系统 detailKey
    private String detailKey;
    // 支付者用户ID
    private Integer payUserId;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    // 支付时间
    private Date payTime;
    // 转人民币汇率
    private BigDecimal toRmbRate;
    // 费用单人民币总金额
    private BigDecimal amountRmb;
    // 公司主体value
    private Integer companyValue;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    // 财务审核时间
    private Date auditTime;
    //发票状态
    private Integer hasInvoice;
    //驳回类型
    private Integer rejectType;
    //财务驳回时间
    private Date rejectTime;

    private String cashierFilePath;

    private String cashierDownloadPath;
    //费用来源 1-默认 2-WMS 3-调拨系统
    private String sourceFrom;
    //项目
    private String projectType;
    //客户编号
    private String customerNum;

    public CostDto castToDto() {
        CostDto costDto = new CostDto();
        BeanUtils.copyProperties(this, costDto);
        return costDto;
    }

}

