package com.blt.other.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.blt.other.commons.utils.PathUtil;
import com.blt.other.cost.dao.CostCashiercallbackDao;
import com.blt.other.cost.service.CostCashiercallbackService;
import com.blt.other.cost.service.CostService;
import com.blt.other.database.model.CostCashiercallbackDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service
public class CostCashiercallbackServiceImpl implements CostCashiercallbackService {

    @Autowired
    CostCashiercallbackDao costCashiercallbackDao;

    @Autowired
    private CostService costService;

    @Value("${url.api.getCashierAnnexApi}")
    private String getCashierAnnexApi;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public Integer saveCostCashiercallbackResponse(CostCashiercallbackDomain costCashiercallbackDomain) {
        return costCashiercallbackDao.insert(costCashiercallbackDomain);
    }

    @Override
    public List<String> downCashierAnnex() {
        List<String> costNoList = costService.listCostNo();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<Resource> httpEntity = new HttpEntity<Resource>(headers);
        for (String costNo : costNoList) {
            String baseUrl = getCashierAnnexApi + "?sourceCode=newCost&detailName=" + costNo;
            String downloadStr = "";
            try {
                ResponseEntity<String> download = restTemplate.getForEntity(baseUrl, String.class);
                downloadStr = download.getBody();
            } catch (Exception e) {
                continue;
            }
            Map<String, String> map = JSONObject.parseObject(downloadStr, Map.class);
            String downloadUrl = map.get("annex");
            if (!downloadUrl.contains("uploadfile")) {
                continue;
            }
            String suffix = downloadUrl.substring(downloadUrl.lastIndexOf("."));
            ResponseEntity<byte[]> response = restTemplate.exchange(downloadUrl, HttpMethod.GET, httpEntity, byte[].class);
            try {
                String filePath = PathUtil.getBasePath() + PathUtil.getPath("cashier/" + costNo + "/" + UUID.randomUUID() + suffix);
                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(response.getBody());
                fos.flush();
                fos.close();
                costService.updateCashierAnnex(costNo, filePath, downloadUrl);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return costNoList;
    }

}
