package com.blt.other.cost.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan/new/pay")
public class  CostPlanNewPayController {

    @Autowired
    private CostPlanService costPlanService;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @PostMapping("/save")
    public Map<String, Object> save(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        CostPlanDomain planDomain = createPlanDomain(request);
        // 保存财务信息
        if (1 == planDomain.getCostForm() || (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend())){
            Integer finansyRecord = doSaveFinansyRecord(planDomain);
        }
        String isTax = request.getParameter("isTax");
        if (null != isTax){
            planDomain.setIsTax(Integer.parseInt(isTax));
        }
        Integer save = costPlanService.save(planDomain);
        return null;
    }

    @PostMapping("/reset")
    public Map<String, Object> reset(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        CostPlanDomain planDomain = createPlanDomain(request);
        // 保存财务信息
        if (1 == planDomain.getCostForm() || (3 == planDomain.getCostForm() && 1 == planDomain.getIsLend())){
            Integer finansyRecord = doSaveFinansyRecord(planDomain);
        }
        String isTax = request.getParameter("isTax");
        if (null != isTax){
            planDomain.setIsTax(Integer.parseInt(isTax));
        }
        Integer save = costPlanService.update(planDomain);
        return null;
    }

    /**
     * 保存填写的财务信息
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain){
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }

    private CostPlanDomain createPlanDomain(HttpServletRequest request) {
        CostPlanDomain costPlanDomain = null;
        String costFormStr = request.getParameter("costForm");
        if (null == costFormStr || "".equals(costFormStr)) {
            return costPlanDomain;
        }
        Integer costForm = Integer.parseInt(costFormStr);
        costPlanDomain = setParams(request);
        costPlanDomain.setCostForm(costForm);
        return costPlanDomain;
    }

    /**
     * 生成付款费用计划实体
     *
     * @param request
     * @return
     */
    private CostPlanDomain setParams(HttpServletRequest request) {
        CostPlanDomain costPlanDomain = new CostPlanDomain();
        String costPlanNo = request.getParameter("costPlanNo");
        String createUsercode = request.getParameter("createUsercode");
        String companyNo = request.getParameter("companyNo");
        Integer subLogisticsSupplierId = null;//二级物流供应商ID，非物流费用单为NULL
        String subLogisticsStr = request.getParameter("subLogisticsSupplierId");
        if (subLogisticsStr != null && !"".equals(subLogisticsStr) && !"null".equals(subLogisticsStr)){
            subLogisticsSupplierId = Integer.valueOf(subLogisticsStr);
        }
        Integer logisticsSupplierId = null;//一级物流供应商ID，非物流费用单为NULL
        String logisticsStr = request.getParameter("logisticsSupplierId");
        if (logisticsStr != null && !"".equals(logisticsStr) && !"null".equals(logisticsStr)){
            logisticsSupplierId = Integer.valueOf(logisticsStr);
        }
        String bankCompany = request.getParameter("bankCompany");
        String bankCardUser = request.getParameter("bankCardUser");
        String bankCard = request.getParameter("bankCard");
        String bankName = request.getParameter("bankName");
        String costRemark = request.getParameter("costRemark");

        costPlanDomain.setCostPlanNo(costPlanNo);
        costPlanDomain.setCreateUsercode(createUsercode);
        costPlanDomain.setCompanyNo(companyNo);
        costPlanDomain.setLogisticsSupplierId(logisticsSupplierId);
        costPlanDomain.setSubLogisticsSupplierId(subLogisticsSupplierId);
        costPlanDomain.setBankCompany(bankCompany);
        costPlanDomain.setBankCardUser(bankCardUser);
        costPlanDomain.setBankCard(bankCard);
        costPlanDomain.setBankName(bankName);
        costPlanDomain.setCostRemark(costRemark);
        return costPlanDomain;
    }
}
