package com.blt.other.module.sys.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.sys.dto.request.*;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.model.DepartmentReviewer;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 部门审核人 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
public interface IDepartmentReviewerService extends IService<DepartmentReviewer> {

    /**
     * 获取部门审核人配置列表
     *
     * @param req req
     * @return res
     */
    IPage<DepartmentReviewerListItem> departmentReviewerList(DepartmentReviewerListReq req);

    /**
     * 修改部门审核人
     *
     * @param req req
     */
    void modifyDepartmentReviewer(ModifyDepartmentReviewerReq req);

    /**
     * 新增部门审核
     *
     * @param req req
     */
    void addDepartmentReviewer(AddDepartmentReviewerReq req);

    /**
     * 删除部门审核
     *
     * @param req req
     */
    void removeDepartmentReviewer(RemoveDepartmentReviewerReq req);

    void importExcel(DepartmentReviewerImportReq excel);

    void exportExcel(HttpServletResponse response, DepartmentReviewerExportReq req);
}
