package com.blt.other.module.cost.service.impl.costplan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostPlanService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * <p>
 * 借支单服务
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class CostPlanNewLend1ServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);
        planDomain.setCostPlanStatus(0);
        planDomain.setLendStatus(1);

        //init 借支单已还金额
        planDomain.setHadPay(BigDecimal.ZERO);
        //init 冲销金额
        planDomain.setCounteract(BigDecimal.ZERO);
        //init 借还单余额
        planDomain.setLendBalance(BigDecimal.ZERO);

        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(planDomain.getTypeNo());

        planDomain.setTypeId(costTypeDomain.getId());
        planDomain.setTypeNo(costTypeDomain.getTypeNo());
        this.check(planDomain);

        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);
        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(planDomain.getTypeNo());

        planDomain.setTypeId(costTypeDomain.getId());
        planDomain.setTypeNo(costTypeDomain.getTypeNo());

        costPlanDao.update(planDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, planDomain.getCostPlanNo()));
    }

    @Override
    public Integer affirm(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.update(costPlanDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, costPlanDomain.getCostPlanNo()));

        CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
        String costNo = getCostNo();
        costDomain.setCompensate(BigDecimal.ZERO);
        costDomain.setRepaymentAppliedAmount(BigDecimal.ZERO);

        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(0);
        costDomain.setAmount(costPlanDomain.getPlanAmount());
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));

        int insert = costDao.insert(costDomain);
        costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成借支单");
        return insert;
    }
}
