package com.blt.other.module.cost.service.impl;

import com.bailuntec.cost.api.dto.CostCompanyFinansysDto;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.module.cost.service.CostCompanyFinansysService;
import com.blt.other.module.cost.vo.CostCompanyDataVo;
import com.blt.other.module.cost.vo.CostCompanyVo;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Service
public class CostCompanyFinansysServiceImpl implements CostCompanyFinansysService {

    @Resource
    CostUrlProperties costUrlProperties;

    @Override
    public CostCompanyVo getCostCompanyVo(Integer mValue) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        params.add("mValue", mValue + "");
        HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(params, headers);
        ResponseEntity<String> response = restTemplate.exchange(costUrlProperties.postCompanyListFinanceApi, HttpMethod.POST, requestEntity, String.class);

        ObjectMapper mapper = new ObjectMapper();
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        }

        CostCompanyVo costCompanyVo = null;
        try {
            strBody = strBody.toLowerCase();
            costCompanyVo = mapper.readValue(strBody, CostCompanyVo.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return costCompanyVo;
    }

    @Override
    public List<CostCompanyFinansysDto> getCostCompanyFinansysDto(CostCompanyVo costCompanyVo) {
        if (null != costCompanyVo) {
            List<CostCompanyDataVo> data = costCompanyVo.getData();
            if (null != data && data.size() >= 1) {
                List<CostCompanyFinansysDto> list = new ArrayList<>();
                CostCompanyFinansysDto costCompanyFinansysDto = null;
                for (CostCompanyDataVo costCompanyDataVo : data) {
                    costCompanyFinansysDto = new CostCompanyFinansysDto();
                    costCompanyFinansysDto.setId(costCompanyDataVo.getId());
                    costCompanyFinansysDto.setBankName(costCompanyDataVo.getBankname());
                    costCompanyFinansysDto.setBankCard(costCompanyDataVo.getBankcard());
                    costCompanyFinansysDto.setBankCardUser(costCompanyDataVo.getBankcarduser());
                    costCompanyFinansysDto.setMainBodyName(costCompanyDataVo.getMainbodyname());
                    costCompanyFinansysDto.setMainBodyValue(costCompanyDataVo.getMainbodyvalue());
                    list.add(costCompanyFinansysDto);
                }
                return list;
            }
        }
        return null;
    }
}
