package com.blt.other.module.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostCashiercallbackDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostCashiercallbackService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.database.model.CostCashiercallbackDomain;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

@Service
public class CostCashiercallbackServiceImpl implements CostCashiercallbackService {

    @Autowired
    CostCashiercallbackDao costCashiercallbackDao;
    @Autowired
    private CostService costService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    CostDao costDao;
    @Autowired
    CostUrlProperties costUrlProperties;

    @Override
    public Integer saveCostCashiercallbackResponse(CostCashiercallbackDomain costCashiercallbackDomain) {
        return costCashiercallbackDao.insert(costCashiercallbackDomain);
    }

    @Data
    static final class Annex {
        private String annex;
    }

    @Override
    public List<String> downCashierAnnex() {
        List<String> costNoList = costDao.selectList(new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostForm, CostDomain.COST_FROM_1)
                .eq(CostDomain::getCostStatus, CostDomain.STATUS_PAYED)
                .eq(CostDomain::getCashierFilePath, ""))
                .stream()
                .map(CostDomain::getCostNo)
                .collect(Collectors.toList());

        HttpHeaders headers = new HttpHeaders();
        HttpEntity<Resource> httpEntity = new HttpEntity<>(headers);
        for (String costNo : costNoList) {
            String baseUrl = costUrlProperties.getCashierAnnexApi + "?sourceCode=newCost&detailName=" + costNo;
            String downloadStr;
            try {
                ResponseEntity<String> download = restTemplate.getForEntity(baseUrl, String.class);
                downloadStr = download.getBody();
            } catch (Exception e) {
                continue;
            }
            Annex annex = JSONObject.parseObject(downloadStr, Annex.class);

            assert annex != null;
            String downloadUrl = annex.getAnnex();

            if (!downloadUrl.contains("uploadfile")) {
                continue;
            }
            String suffix = downloadUrl.substring(downloadUrl.lastIndexOf("."));
            ResponseEntity<byte[]> response = restTemplate.exchange(downloadUrl, HttpMethod.GET, httpEntity, byte[].class);
            try {
                String filePath = PathUtil.getBasePath() + PathUtil.getPath("cashier/" + costNo + "/" + UUID.randomUUID() + suffix);
                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(Objects.requireNonNull(response.getBody()));
                fos.flush();
                fos.close();
                costService.updateCashierAnnex(costNo, filePath, downloadUrl);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return costNoList;
    }

}
