package com.blt.other.common.job;

import com.blt.other.module.cost.service.UserCostFinansysService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class UserCostFinansysSyncJob extends QuartzJobBean {

    private static Logger logger = LoggerFactory.getLogger(UserCostFinansysSyncJob.class);

    @Autowired
    private UserCostFinansysService userCostFinansysService;
    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String result = userCostFinansysService.syncUserFinansys();
        if (!"新增 0 条记录，更新 0 条记录".equals(result)) {
            logger.info("Job：从财务系统获取财务信息," + result);
        }
    }
}
