package com.blt.other.module.cost.utils;

import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.common.StringUtils;
import com.bailuntec.common.exception.BizException;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.blt.other.common.util.PathUtil;
import com.mchange.v2.uid.UidUtils;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

/**
 * 费用模块文件上传、下载工具类
 */
@Slf4j
public class CostFileUtil {
    private static final String REGEX_CHINESE = "[\u4e00-\u9fa5]";// 中文正则


    public static String upload(MultipartFile file, String filePath) {

        // 获取文件名
        String fileName = file.getOriginalFilename().replaceAll("_", "");

        // fileName处理
        fileName = filePath + UUID.randomUUID() + "&" + fileName;
        // 文件对象
        File dest = new File(fileName);
        // 创建路径
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try {
            file.transferTo(dest);
        } catch (IOException e) {
//            logger.error("affirmFile 发生错误",e);
        }
        return fileName;
    }


    public static String upload(String netUrl, String filePath) throws IOException {

        RestTemplate restTemplate = new RestTemplate();
        byte[] bytes = restTemplate.getForObject(netUrl, byte[].class);
        if (bytes == null || bytes.length == 0) {
            throw new RuntimeException("附件内容为空");
        }

        int dotIndex = netUrl.lastIndexOf(".");

        String fileName = filePath + UUID.randomUUID() + "." + netUrl.substring(dotIndex + 1);

        File dest = new File(fileName);
        // 创建路径
        if (!dest.exists()) {    //文件不存在则创建文件，先创建目录
            File dir = new File(dest.getParent());
            dir.mkdirs();
            dest.createNewFile();
        }

        OutputStream outputStream = new FileOutputStream(fileName);
        outputStream.write(bytes);
        outputStream.close();

        return fileName;
    }


    public static String saveImage(MultipartFile multipartFile) throws IOException {
        //临时文件地址
        String basePath = PathUtil.getBasePath() + PathUtil.getPath("cost/");
        //文件名
        String fileName = multipartFile.getOriginalFilename();
        if (StringUtils.isEmpty(fileName)) {
            throw new BizException("上传文件为空，请重新上传");
        }

        String fileSuffix = fileName.substring(fileName.lastIndexOf("."));
        String localFileName = IdWorker.getId() + fileSuffix;
        String filePath = basePath + File.separator + localFileName;
        File localFile = new File(filePath);
        File imagePath = new File(basePath);
        if (!imagePath.exists()) {
            boolean ignore = imagePath.mkdirs();
        }
        multipartFile.transferTo(localFile);
        return qiniuUpload(localFile);
    }

    public static String qiniuUpload(String netUrl) throws IOException {
        RestTemplate restTemplate = new RestTemplate();
        byte[] bytes = restTemplate.getForObject(netUrl, byte[].class);
        if (bytes == null || bytes.length == 0) {
            throw new RuntimeException("附件内容为空");
        }

        int dotIndex = netUrl.lastIndexOf(".");
        File tempFile = File.createTempFile(UidUtils.VM_ID + "fee-original", "."+netUrl.substring(dotIndex + 1));
        OutputStream outputStream = new FileOutputStream(tempFile.getAbsolutePath());
        outputStream.write(bytes);
        outputStream.close();
        String path = "http://cost-service.blsct.com/" + qiniuUpload(tempFile);
        tempFile.deleteOnExit();
        return path;
    }

    public static String qiniuUpload(MultipartFile file) throws IOException {
        File tempFile = File.createTempFile(UidUtils.VM_ID + "fee-original", file.getOriginalFilename().replaceAll("_", ""));
        file.transferTo(tempFile);
        String path = "http://cost-service.blsct.com/" + qiniuUpload(tempFile);
        tempFile.deleteOnExit();
        return path;
    }

    public static String qiniuUpload(File localFilePath) {
        //1、构造一个带指定Zone对象的配置类
//        Configuration cfg = new Configuration(Zone.zone2());
        Configuration cfg = new Configuration(Region.region2());
        //2、其他参数参考类注释
        UploadManager uploadManager = new UploadManager(cfg);
        //3、生成上传凭证，然后准备上传
        String accessKey = "QSvtvN4Ons1CiNzaMGqx8XmDaiM1L0ZqSwJ2YoTn";
        String secretKey = "yagRd-cBOVhkRGGT-o_reMqNVjI8_k7YwoTXkhrm";
        String bucket = "cost-service";

        //七牛云文件名
        String key = localFilePath.getName() + "-" + UidUtils.VM_ID + "-" + localFilePath.getName();
        Auth auth = Auth.create(accessKey, secretKey);
        String upToken = auth.uploadToken(bucket);
        try {
            Response response = uploadManager.put(localFilePath, key, upToken);
            //4、解析上传成功的结果
            DefaultPutRet putRet = JsonUtilByFsJson.jsonToBean(response.bodyString(), DefaultPutRet.class);
            return putRet.key;
        } catch (QiniuException ex) {
            Response r = ex.response;
            System.err.println(r.toString());
            try {
                System.err.println(r.bodyString());
            } catch (QiniuException ex2) {
                //ignore
            }
            return null;
        }
    }


}
