package com.blt.other.common.exception;


import com.bailuntec.common.JsonUtilByJackson;
import com.blt.other.common.interceptor.mail.MailService;
import com.blt.other.common.wrapper.RequestBakRequestWrapper;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.HashMap;
import java.util.Map;

/**
 * 统一异常处理器
 *
 * @author robbendev
 */
@ControllerAdvice
@ResponseBody
@Slf4j
public class GlobalExceptionHandler {

    @Resource
    MailService mailService;

    @Value("${spring.profiles.active}")
    private String profile;

    /**
     * 自定义异常
     */
    @ResponseBody
    @ExceptionHandler(BizRuntimeException.class)
    public Map<String, Object> handleBizRuntimeException(HttpServletRequest request,
                                                         BizRuntimeException e) {
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", e.getMessage());
        result.put("message", e.getMessage());
        result.put("code", e.getCode());

        log.error(e.getMessage(), e);
        return result;
    }


    /**
     * 数据库唯一键冲突异常
     */
    @ResponseBody
    @ExceptionHandler({SQLIntegrityConstraintViolationException.class, MySQLIntegrityConstraintViolationException.class})
    public Map<String, Object> handleSQLIntegrityConstraintViolationException(HttpServletRequest request,
                                                                              RuntimeException e) {
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", "数据重复");
        result.put("message", "数据重复");
        result.put("code", "500");


        log.error(e.getMessage(), e);
        return result;
    }


    /**
     * 自定义异常
     */
    @ResponseBody
    @ExceptionHandler({RuntimeException.class})
    public Map<String, Object> handleRuntimeException(HttpServletRequest request,
                                                      RuntimeException e) {
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", e.getMessage());
        result.put("message", e.getMessage());
        result.put("code", "500");

        log.error(e.getMessage(), e);
        return result;
    }


    /**
     * 未捕获异常
     */
    @ResponseBody
    @ExceptionHandler(Exception.class)
    public Map<String, Object> handleException(HttpServletRequest request,
                                               Exception ex) {
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", ex.getMessage() + ex.getStackTrace()[0].toString());
        result.put("message", ex.getMessage() + ex.getStackTrace()[0].toString());
        result.put("code", "500");

        RequestBakRequestWrapper bakRequestWrapper = (RequestBakRequestWrapper) request;


        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);

        ErrorLog errorLog = ErrorLog.builder()
                .uri(bakRequestWrapper.getRequestURI())
                .param(JsonUtilByJackson.writeValueAsString(bakRequestWrapper.getParameterMap()))
                .payload(bakRequestWrapper.getCachedContent().toString())
                .errorMsg(ex.getMessage())
                .StackTrace(sw.toString())
                .build();

        log.error(ex.getMessage(), ex);
        mailService.sendSimpleMail("robbendev@qq.com", "fee_" + profile + "_异常", JsonUtilByJackson.writeValueAsString(errorLog));

        return result;
    }


    @Data
    @Builder
    static class ErrorLog {

        private String uri;
        private String traceId;
        private String param;
        private String payload;
        private String errorMsg;
        private String StackTrace;

    }
}
