package com.blt.other.module.cost.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.database.model.LogisticsSupplierBankDomain;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dto.request.*;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.dto.response.GetLogisticsBankResp;
import com.blt.other.module.cost.dto.response.GetLogisticsCodeResp;
import com.blt.other.module.cost.service.CostTypeKindService;
import com.blt.other.module.cost.service.CostTypeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;

@Service
@Slf4j
public class CostTypeServiceImpl extends ServiceImpl<CostTypeDao, CostTypeDomain> implements CostTypeService {
    @Resource
    AccountingSubjectMapper accountingSubjectMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public void addCostType(CostTypeAddReq req) {
        CostTypeDomain costTypeDomain = new CostTypeDomain();
        costTypeDomain.setAccountingSubjectNo(req.getAccountingSubjectNo());
        costTypeDomain.setTypeNo(IdWorker.getIdStr());
        costTypeDomain.setTypeName(req.getTypeName());
        costTypeDomain.setDescription(req.getDescription());

        costTypeDomain.setCostTemplateType(this.getCostTemplateType(req.getType()));

        this.save(costTypeDomain);

        if (req.getType().equals(1)) {
            CostTypeDomain lendCostTypeDomain = new CostTypeDomain();
            lendCostTypeDomain.setCostTemplateType(CostTypeDomain.borrow);
            lendCostTypeDomain.setAccountingSubjectNo("1345912843756503041");
            lendCostTypeDomain.setTypeNo(IdWorker.getIdStr());
            lendCostTypeDomain.setTypeName(req.getTypeName());
            lendCostTypeDomain.setDescription(req.getDescription());
        }

    }

    @Override
    public Page<CostTypeResult> queryPage(CostTypeQueryPageReq req) {
        IPage<CostTypeResult> page = new Page<>(req.getPageNum(), req.getPageSize());

        req.setCostTemplateType(this.getCostTemplateType((req.getType())));
        page = baseMapper.queryPage(page, req);
        return (Page<CostTypeResult>) page;
    }

    @Override
    public void modifyCostType(CostTypeModifyReq req) {
        OaUser oaUser = oaUserMapper.selectByOaUserId(req.getCurrentUserId());


        log.info("{} 更新费用类型", oaUser.getUserName());
        if (req.getTypeNo() != null) {
            CostTypeDomain costTypeDomain = baseMapper.selectByNo(req.getTypeNo());
            costTypeDomain.setTypeName(req.getTypeName().trim());
            costTypeDomain.setDescription(req.getDescription());
            costTypeDomain.setUpdateUserId(oaUser.getOaUserId());
            costTypeDomain.setUpdateUser(oaUser.getUserName());
            costTypeDomain.setLastUpdateTime(LocalDateTime.now());
            costTypeDomain.setAccountingSubjectNo(req.getAccountingSubjectNo());

            log.info("{} 更新会计一级科目", oaUser.getUserName());

            this.updateById(costTypeDomain);
        }


    }

    @Override
    public CostTypeResult queryDetail(Integer id) {
        return baseMapper.queryDetail(id);
    }

    @Override
    public void deleteById(Integer id) {
        baseMapper.deleteById(id);
    }

    @Override
    public CostTypeResult queryByNo(String typeNo) {
        return baseMapper.queryByNo(typeNo);
    }

    @Override
    public GetLogisticsCodeResp getLogisticsCode() {
        GetLogisticsCodeResp resp = new GetLogisticsCodeResp();
        resp.setSuccess(true);
        resp.setLogisticsCode("22222");
        return resp;
    }

    @Resource
    CostTypeKindService costTypeKindService;

    @Override
    public GetLogisticsBankResp getLogisticsBank(String subSupplierName) {
        GetLogisticsBankResp resp = new GetLogisticsBankResp();
        resp.setSuccess(true);
        LogisticsSupplierBankDomain bankDomain = costTypeKindService.getLogisticsBank(subSupplierName);
        resp.setBankInfo(bankDomain);
        return resp;
    }

    @Override
    public void importExcel(CostTypeImportExcelReq excel) {

    }

    @Override
    public void exportExcel(HttpServletResponse response, CostTypeExportExcelReq req) {

    }

    /**
     * 根据ui类型获取费用类型 对应的费用模版类型
     *
     * @param type 1-费用类型 2-收入类型
     * @return res
     */
    private Integer getCostTemplateType(Integer type) {
        if (type.equals(1)) {
            return CostTypeDomain.feeType;
        } else if (type.equals(2)) {
            return CostTypeDomain.incomeType;
        } else if (type.equals(3)) {
            return CostTypeDomain.borrow;
        } else {
            throw new BizRuntimeException("invalid type");
        }
    }

}
