package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dto.request.AppCheckCostListReq;
import com.blt.other.module.cost.dto.request.AppCostPassReq;
import com.blt.other.module.cost.dto.request.AppCostRejectReq;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.AppCostService;
import com.blt.other.module.cost.service.impl.costcheck.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/14 1:22 下午
 */
@Service
public class AppCostServiceImpl implements AppCostService {

    @Resource
    CostDao costDao;


    @Override
    public Page<CostDto> appCheckCostList(AppCheckCostListReq req) {
        IPage<CostDomain> costDomainIPage = new Page<>(req.getPageNum(), req.getPageSize())
        return (Page<CostDto>) costDao.appCheckCostList(costDomainIPage, req).convert(CostDomain::castToDto);
    }

    @Override
    public void appCostPass(AppCostPassReq req) {
        CostState costState = this.getCostState(req.getCostNo());
        costState.handle();
    }

    @Override
    public void appCostReject(AppCostRejectReq req) {
        CostState costState = this.getCostState(req.getCostNo());
        costState.refuse(req.getRejectReason());
    }

    private CostState getCostState(String costNo) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        switch (costDomain.getCostStatus()) {
            case CostDomain.STATUS_DEPARTMENT_CHECK:
                return SpringContextUtil.getBean(DepartmentCheckState.class);
            case CostDomain.STATUS_FINANCIAL_CHECK:
                return SpringContextUtil.getBean(FinancialCheckState.class);
            case CostDomain.STATUS_HR_CHECK:
                return SpringContextUtil.getBean(HrCheckState.class);
            case CostDomain.STATUS_FINAL_CHECK:
                return SpringContextUtil.getBean(FinalCheckState.class);
            default:
                throw new BizRuntimeException("invalid cost status");
        }
    }
}
