package com.blt.other;

import com.blt.other.module.cost.model.CostTemplateCol;
import com.blt.other.module.cost.service.ICostTemplateColService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/15 11:08 上午
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("test")
public class MybatisTest {

    @Resource
    ICostTemplateColService costTemplateColService;

    @Test
    public void testBatchInsert() {
        long time = System.currentTimeMillis();
        CostTemplateCol costTemplateCol = new CostTemplateCol();
        costTemplateCol.setAutoRuleCheckVal("test");
        costTemplateCol.setCostTemplateId(1);
        costTemplateCol.setCostTemplateBaseColId(1);

        List<CostTemplateCol> costTemplateColList = Stream.iterate(costTemplateCol, n -> costTemplateCol)
                .limit(10000)
                .collect(Collectors.toList());
        costTemplateColList.forEach(costTemplateColService::save);

        System.out.println("分条插入时间:" + (System.currentTimeMillis() - time) / 1000 + "s");


        long time2 = System.currentTimeMillis();

        CostTemplateCol costTemplateCol2 = new CostTemplateCol();
        costTemplateCol2.setAutoRuleCheckVal("test");
        costTemplateCol2.setCostTemplateId(1);
        costTemplateCol2.setCostTemplateBaseColId(1);

        List<CostTemplateCol> costTemplateColList2 = Stream.iterate(costTemplateCol2, n -> costTemplateCol2)
                .limit(10000)
                .collect(Collectors.toList());
        costTemplateColService.saveBatch(costTemplateColList2);
        System.out.println("批量插入时间:" + (System.currentTimeMillis() - time2));
    }
}
