package com.blt.other.module.cost.service.impl.costplan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostPlanService;
import com.blt.other.module.cost.utils.CostUtils;
import com.blt.other.module.database.model.CostPlanDomain;
import com.blt.other.module.database.model.CostPlanTempDomain;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class CostPlanNewPayServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);

        List<CostPlanTempDomain> list = costPlanTempDao.selectListByPlanNo(planDomain.getCostPlanNo());
        BigDecimal planAmount = list.stream().map(CostPlanTempDomain::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        planDomain.setPlanAmount(planAmount);
        planDomain.setCostPlanStatus(0);
        this.check(planDomain);

        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);

        List<CostPlanTempDomain> list = costPlanTempDao.selectListByPlanNo(planDomain.getCostPlanNo());
        BigDecimal planAmount = list.stream().map(CostPlanTempDomain::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        planDomain.setPlanAmount(planAmount);
        costPlanDao.update(planDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, planDomain.getCostPlanNo()));
    }

    @Override
    public Integer affirm(String costPlanNo) {
        // 获取 temp 表中的记录
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.update(costPlanDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, costPlanDomain.getCostPlanNo()));


        List<CostPlanTempDomain> costPlanTempDomains = costPlanTempDao.selectListByPlanNo(costPlanNo);


        if (costPlanTempDomains.stream().anyMatch(temp -> null == temp.getTypeNo() || null == temp.getKindNo())) {
            throw new RuntimeException("存在有金额、但是没有选择类型的子项目");
        }

        // 将 List<CostPlanTempDomain> 转为 List<CostDetailDomain>
        AtomicInteger index = new AtomicInteger(1);
        List<CostDetailDomain> costDetailDomainList = costPlanTempDomains.stream().map(costPlanTempDomain ->
                this.tempToDetail(costPlanTempDomain, costPlanDomain, index.getAndIncrement())
        ).collect(Collectors.toList());

        // 根据大类分类
        Map<String, List<CostDetailDomain>> detailMap = costDetailDomainList.stream().collect(
                Collectors.groupingBy(CostDetailDomain::getTypeNo)
        );

        // 按照不同的大类生成付款费用单、费用详情
        detailMap.forEach((typeNo, costDetailDomains) -> {
            // 生成付款费用单
            CostDomain costDomain = this.planToCost(costPlanNo);
            String costNo = CostUtils.getIdNum();
            // 差额单（冲销借支单自动生成的补差额的付款费用）的单号以 “S” 打头
            if (costPlanNo.startsWith("S")) {
                costNo = "S" + costNo;
            }
            CostDomain costByNo = costDao.selectByCostNo(costNo);
            while (null != costByNo && null != costByNo.getId()) {
                costNo = CostUtils.getIdNum();
                if (costPlanNo.startsWith("S")) {
                    costNo = "S" + costNo;
                }
                costByNo = costDao.selectByCostNo(costNo);
            }
            costDomain.setCostNo(costNo);
            costDomain.setTypeNo(typeNo);
            costDomain.setTypeName(costDetailDomains.get(0).getTypeName());
//            CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(typeNo);
//            costDomain.setSubjectCode(costTypeDomain.getSubjectCode());

//            costDomain.setKindNo(costDetailDomains.get(0).getKindNo());
//            costDomain.setKindName(costDetailDomains.get(0).getKindName());
            if (null == costDomain.getAmount()) {
                costDomain.setAmount(new BigDecimal(0));
            }
            for (CostDetailDomain costDetailDomain : costDetailDomains) {
                costDomain.setAmount(costDomain.getAmount().add(costDetailDomain.getAmount()));
            }
            costDomain.setDic(costDetailDomains.get(0).getDic());
            costDomain.setCostStatus(0);
            BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
            costDomain.setToRmbRate(toRmbRate);
            costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));

            // 生成付款费用详情单
            for (CostDetailDomain costDetailDomain : costDetailDomains) {
                costDetailDomain.setCostNo(costNo);
                // 生成付款费用详情
                costDetailDao.insert(costDetailDomain);
            }

            // 执行添加记录流程
            costDomain.setCostPlanNo(costPlanNo);
            int insert = costDao.insert(costDomain);
            if (insert >= 1) {
                // 记录日志
                costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成付款单");

            }
        });
        return detailMap.keySet().size();
    }
}
