package com.bailuntec.cost.api;


import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.LogisticsCostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.bailuntec.cost.api.dto.WageCostDto;
import com.bailuntec.cost.api.response.CostResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "bailuntec-cost-api", url = "http://api.fee.bailuntec.com/purchase/other/cost/api")
public interface CostApi {


    @ApiOperation("接受工资单，自动生成付款费用单到财务审核")
    @PostMapping("/pushWageCost")
    CostResult<Void> pushWageCost(@RequestBody WageCostDto wageCostDto);

    @ApiOperation("接收物流单，自动生成付款费用单到财务审核")
    @PostMapping("/pushLogisticsCost")
    CostResult<Void> pushLogisticsCost(@RequestBody LogisticsCostDto logisticsCostDto);

    @ApiOperation("吴通接收物流单，自动生成收款费用单到财务审核")
    @PostMapping("/pushLogisticsReceipt")
    CostResult<Void> pushLogisticsReceipt(@RequestBody LogisticsCostDto logisticsCostDto);


    @ApiOperation("获取所有费用单和采购单")
    @GetMapping("/manageCostList")
    CostResult<List<ManageCostDto>> manageCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                                   @RequestParam(name = "endDate", required = false) String endDateStr,
                                                   @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                                   @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                                   @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                                   @RequestParam(name = "companyName", required = false) String companyName,
                                                   @RequestParam(name = "departmentName", required = false) String departmentName,
                                                   @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                                   @RequestParam(name = "payUserId", required = false) Integer payUserId);

    @ApiOperation("查询所有的物流费用单和采购单")
    @GetMapping("/logisticsCostList")
    CostResult<List<ManageCostDto>> logisticsCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                                      @RequestParam(name = "endDate", required = false) String endDateStr,
                                                      @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                                      @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                                      @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                                      @RequestParam(name = "companyName", required = false) String companyName,
                                                      @RequestParam(name = "departmentName", required = false) String departmentName,
                                                      @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                                      @RequestParam(name = "payUserId", required = false) Integer payUserId);

    @ApiOperation("获取资产负债表相关费用单")
    @GetMapping("/balanceSheetCost")
    CostResult<List<CostDto>> balanceSheetCostList(@RequestParam(name = "startDate") String startDateStr,
                                                   @RequestParam(name = "endDate") String endDateStr);

    @GetMapping("/noPayCost")
    @ApiOperation("查询原来传输到数据中心时为待支付状态 变成 已支付状态后的费用单")
    CostResult<List<CostDto>> getNoPayCost(@RequestParam(name = "costNoList") List<String> costNoList);


    @ApiOperation("吴通新增 根据费用单号获取费用单大类")
    @GetMapping("/type/{costNo}")
    CostResult<String> getTypeName(@PathVariable("costNo") String costNo);

    @ApiOperation("获取费用系统列表")
    @GetMapping({"/getCostList"})
    CostResult<List<CostDto>> getCostList(@RequestParam(name = "startDate") String startDate,
                                          @RequestParam(name = "endDate") String endDate,
                                          @RequestParam(name = "pageNum") Integer pageNum,
                                          @RequestParam(name = "pageSize") Integer pageSize);
}
