package com.blt.other.module.database.model;

import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostTypeKindDao;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;

@Data
public class CostPlanTempDomain {
    // 费用单表 id
    private Integer id;
    private String costPlanNo; // 费用计划编号
    private String tempNo; // 计划缓存编号
    private String kindNo; // 种类编号
    private String filePath; // 文件地址
    private BigDecimal amount; // 费用总金额
    private String costReason; // 付款理由
    private String dic; // 币种
    private String typeNo; // 大类编号


    public CostPlanTempDto castToDto(){
        CostTypeKindDao costTypeKindDao = SpringContextUtil.getBean(CostTypeKindDao.class);
        CostPlanTempDto dto = new CostPlanTempDto();
        BeanUtils.copyProperties(this, dto);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(this.getKindNo());
        if (null != costTypeKindDomain) {
            dto.setTypeNameDto(costTypeKindDomain.getTypeName());
            dto.setKindNameDto(costTypeKindDomain.getKindName());
        }

        dto.setFileName(PathUtil.getFileName(dto.getFilePath()));

        return dto;
    }
}

