package com.blt.other.database.model;

import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostTypeDao;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;


@TableName("cost_plan_temp")
@Data
public class CostPlanTempDomain {
    // 费用单表 id

    @TableId(type = IdType.AUTO)
    private Integer id;
    private String costPlanNo; // 费用计划编号
    private String tempNo; // 计划缓存编号

    private String filePath; // 文件地址
    private BigDecimal amount; // 费用总金额
    private String costReason; // 付款理由
    private String dic; // 币种
    private String typeNo; // 大类编号

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;

    private String lendType;

    @ApiModelProperty("项目")
    private String projectType;

    @ApiModelProperty("客户编号")
    private String customerNum;


    public CostPlanTempDto castToDto() {

        CostTypeDao costTypeDao = SpringContextUtil.getBean(CostTypeDao.class);

        CostPlanTempDto dto = new CostPlanTempDto();
        BeanUtils.copyProperties(this, dto);

        dto.setTypeNameDto(costTypeDao.selectByNo(typeNo).getTypeName());
        dto.setFileName(PathUtil.getFileName(dto.getFilePath()));

        return dto;
    }
}

