package com.blt.other.module.sys.dto.response;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.blt.other.module.sys.model.CostReviewer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/21 9:38 上午
 */
@Data
public class DepartmentReviewerListItem {


    @ExcelIgnore
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ExcelIgnore
    @ApiModelProperty(value = "一级部门id")
    private Integer primaryDepartmentId;

    @ApiModelProperty(value = "一级部门")
    @ExcelProperty(value = "一级部门")
    private String primaryDepartmentName;

    @ExcelIgnore
    @ExcelProperty(value = "二级部门id")
    private Integer secondDepartmentId;

    @ApiModelProperty(value = "二级部门")
    @ExcelProperty(value = "二级部门")
    private String secondDepartmentName;

    @ApiModelProperty(value = "自动审核金额")
    @ExcelProperty(value = "自动审核金额")
    private BigDecimal autoReviewAmount;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ExcelIgnore
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ExcelIgnore
    @ApiModelProperty(value = "最近一次更新时间")
    private LocalDateTime lastUpdateTime;

    @ExcelIgnore
    @ApiModelProperty(value = "更新人id")
    private Integer updateUserId;

    @ExcelIgnore
    @ApiModelProperty(value = "更新人")
    private String updateUserName;

    @TableField(exist = false)
    @ApiModelProperty(value = "公司")
    @ExcelProperty(value = "公司")
    private String companyName;

    @TableField(exist = false)
    @ExcelIgnore
    private List<CostReviewer> costReviewerList;

    @TableField(exist = false)
    @ExcelProperty(value = "审核人")
    private String costReviewerNames;
}
