package com.blt.other.module.netsuite.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.blt.other.module.netsuite.dto.NetsuiteLogDto;
import com.blt.other.module.netsuite.model.NetsuiteLogDomain;
import org.apache.ibatis.annotations.Param;
import org.mapstruct.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-04-28
 * @Modified by:
 */
@Mapper
@Repository
public interface NetsuiteLogDao extends BaseMapper<NetsuiteLogDomain> {

    /**
     * 更新或插入
     *
     * @param netsuiteLogDomain
     * @return
     */
    Integer upsert(NetsuiteLogDomain netsuiteLogDomain);

    /**
     * 查询最早更新且未推送的前Top条数据
     *
     * @param top
     * @return
     */
    List<NetsuiteLogDto> selectNonPublishTop(@Param("script") Integer script, @Param("top") Integer top);

    /**
     * 更新推送状态
     *
     * @param map
     * @return
     */
    Integer updatePublishStatus(Map<String,Object> map);
}
