package com.blt.other.module.cost.service.impl.costplan;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.common.exception.BizException;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostPlanDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dto.request.AddItemReq;
import com.blt.other.module.cost.dto.request.AddItemResp;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.*;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.module.cost.service.impl.CostCompanyServiceImpl;
import com.blt.other.module.cost.service.impl.CostTypeServiceImpl;
import com.blt.other.module.cost.service.impl.cost.AbstractCostService;
import com.blt.other.module.cost.utils.CostFileUtil;
import com.blt.other.module.cost.vo.CostPlanEnumVo;
import com.mchange.v2.uid.UidUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;

import javax.annotation.Resource;
import java.io.*;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.*;

import static com.blt.other.common.wrapper.ThrowingConsumer.handlingConsumerWrapper;
import static com.blt.other.common.wrapper.ThrowingConsumer.throwingConsumerWrapper;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/17 10:13 上午
 */
@Slf4j
public class CostPlanServiceFactory {

    /**
     * 费用类型 包括付款 借还 9
     */

    private static final Integer FEE_TYPE = 0b1001;
    /**
     * 收入类别 包括收款 4
     */
    private static final Integer INCOME_TYPE = 0b0100;

    /**
     * 借支类别 包括借支 2
     */
    private static final Integer BORROW = 0b0010;

    private static CostTypeService getCostTypeService(){
        return SpringContextUtil.getBean(CostTypeServiceImpl.class);
    }

    private static CostCompanyService getCostCompanyService(){
        return SpringContextUtil.getBean(CostCompanyServiceImpl.class);
    }

    private static CostPlanTempService getCostPlanTempService(){
        return SpringContextUtil.getBean(CostPlanTempServiceImpl.class);
    }

    public static CostPlanService getCostPlanService() {
        return SpringContextUtil.getBean(DefaultCostPlanServiceImpl.class);
    }

    public static CostService getCostService() {
        return SpringContextUtil.getBean(AbstractCostService.class);
    }


    public static CostPlanService getCostPlanService(String costPlanNo) {
        CostPlanDao costPlanDao = SpringContextUtil.getBean(CostPlanDao.class);
        return getCostPlanService(costPlanDao.selectByNo(costPlanNo));
    }

    public static CostPlanService getCostPlanService(CostPlanDomain costPlanDomain) {

        if (costPlanDomain.getCostForm().equals(1)) {
            return SpringContextUtil.getBean(CostPlanNewPayServiceImpl.class);
        }
        if (costPlanDomain.getCostForm().equals(2)) {
            return SpringContextUtil.getBean(CostPlanNewReceiptServiceImpl.class);
        }
        if (costPlanDomain.getCostForm().equals(3) && costPlanDomain.getIsLend().equals(1)) {
            return SpringContextUtil.getBean(CostPlanNewLend1ServiceImpl.class);
        }
        if (costPlanDomain.getCostForm().equals(3) && costPlanDomain.getIsLend().equals(2)) {
            return SpringContextUtil.getBean(CostPlanNewLend2ServiceImpl.class);
        }
        return SpringContextUtil.getBean(DefaultCostPlanServiceImpl.class);
    }

    /**
     * 根据上传的文件构建
     *
     * @param zip
     * @return
     */
    public static Map<CostPlanService, List<CostPlanDomain>> getCostPlanService(File zip,String userCode) throws Exception {
        Map<CostPlanService, List<CostPlanDomain>> costPlanServiceListMap = new HashMap<>();
        Map<String, File> fileMap = new HashMap<>();
        List<String> createdPlanNos = new ArrayList<>();
        try (ZipArchiveInputStream inputStream = new ZipArchiveInputStream(new BufferedInputStream(new FileInputStream(zip)))) {
            ZipArchiveEntry entry;
            while ((entry = inputStream.getNextZipEntry()) != null) {
                if (!entry.isDirectory()) {
                    File tempFile = File.createTempFile(UidUtils.VM_ID,entry.getName());
                    OutputStream outputStream = new FileOutputStream(tempFile);
                    IOUtils.copy(inputStream,outputStream);
                    outputStream.close();
                    fileMap.put(entry.getName(),tempFile);
                }
            }
            File feeExcel = fileMap.get("costPlan.xlsx");
            if(feeExcel == null){
                throw new Exception("缺少文件【costPlan.xlsx】");
            }
            InputStream feeIn = new FileInputStream(feeExcel);
            Workbook wb = new XSSFWorkbook(feeIn);
            for(int sheetIndex=0;sheetIndex<=3;sheetIndex++){
                Sheet sheet = wb.getSheetAt(sheetIndex);
                if (sheet != null && sheet.getLastRowNum() > 0) {
                    costPlanServiceListMap.putAll(getCostPlan(sheet,fileMap,userCode,createdPlanNos));
                }
            }

        } catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        } catch (IOException ioException) {
            ioException.printStackTrace();
            throw ioException;
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }

        return costPlanServiceListMap;
    }

    /**
     * 获取费用计划
     * @param sheet
     * @param fileMap
     * @param userCode
     * @return
     * @throws Exception
     */
    private static Map<CostPlanService, List<CostPlanDomain>> getCostPlan(Sheet sheet,Map<String, File> fileMap,String userCode,List<String> createdPlanNos) throws Exception {
        Row firstRow = sheet.getRow(0);
        String sheetName = sheet.getSheetName();
        Map<CostPlanService, List<CostPlanDomain>> costPlanServiceListMap = new HashMap<>();
        List<CostPlanDomain> costPlanDomainList = new ArrayList<>();
        Map<String, CostTypeResult> costTypeResultMap = new HashMap<>();
        Map<Integer, Map<CostPlanDomain,List<AddItemReq>>> costPlanAndItemMap = new HashMap<>();
        //公司主体映射
        Map<String, CostCompanyDomain> costCompanyDomainMap = getCostCompanyService().costCompanyMap();
        for (int i = 1; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);

            JSONObject jsonObject = new JSONObject();
            for (int j = 0; j < firstRow.getLastCellNum(); j++) {
                String costPlanField = CostPlanEnumVo.getCostPlanField(sheetName, firstRow.getCell(j).toString());
                if (!costPlanField.equals("")) {
                    if(!costPlanField.equals("costRemark") && (row.getCell(j) == null || row.getCell(j).toString().trim().equals(""))){
                        throw new BizException("请填写必填项");
                    }
                    if(costPlanField.equals("costRemark") && sheetName.equals("付款") && (row.getCell(j) == null || row.getCell(j).toString().trim().equals("")))
                    {
                        throw new BizException("付款单备注为必填项");
                    }
                    jsonObject.put(costPlanField, row.getCell(j).toString());
                }
            }
            CostPlanDomain costPlanDomain = jsonObject.toJavaObject(CostPlanDomain.class);

            costPlanDomain.setAttach(new ArrayList<>());

            //上传文件
            File currentFile = fileMap.get(costPlanDomain.getFilePath());
            String path = CostFileUtil.qiniuUpload(currentFile);
            if (path == null) {
                throw new Exception("上传附件失败");
            }
            path = "http://dcfile.blsct.com/" + path;
            //类别
            CostTypeResult costTypeResult = costTypeResultMap.get(sheetName + costPlanDomain.getTypeName());
            if (costTypeResult == null) {
                costTypeResult = getCostType(sheetName, costPlanDomain.getTypeName());
                costTypeResultMap.put(sheetName + costPlanDomain.getTypeName(), costTypeResult);
            }

            //设置用户编号
            costPlanDomain.setCreateUsercode(userCode);

            //设置付款/收款主体
            CostCompanyDomain costCompanyDomain = costCompanyDomainMap.get(costPlanDomain.getCompanyName());
            costPlanDomain.setCompanyNo(costCompanyDomain.getCompanyNo());
            costPlanDomain.setCompanyValue(costCompanyDomain.getValue());
            if (!sheetName.equals("付款")) {
                if(sheetName.equals("借还")){
                    //借还的lendType = 借支的借支类别
                    CostTypeResult lendTypeCostTypeResult = costTypeResultMap.get("借支" + costPlanDomain.getLendType());
                    if (lendTypeCostTypeResult == null) {
                        lendTypeCostTypeResult = getCostType("借支", costPlanDomain.getLendType());
                        costTypeResultMap.put("借支" + costPlanDomain.getLendType(), lendTypeCostTypeResult);
                    }
                    //借支信息
                    CostDomain supCost = getCostService().getCostByCostNo(costPlanDomain.getSupCostNo());
                    if(supCost == null || !supCost.getCreateUsercode().equalsIgnoreCase(userCode) || !(supCost.getCostForm().equals(3) && supCost.getIsLend().equals(1))){
                        throw new BizRuntimeException("费用单"+costPlanDomain.getSupCostNo()+"无法作为借还单的关联借支单，请检查是否填写正确");
                    }
                    //借支
                    costPlanDomain.setCounteract(supCost.getCounteract());
                    costPlanDomain.setLendBalance(supCost.getLendBalance());
                    costPlanDomain.setDic(supCost.getDic());
                    costPlanDomain.setPlanAmount(supCost.getCounteract().add(supCost.getLendBalance()));
                    //借还总计
                    costPlanDomain.setPayPlanAmount(costPlanDomain.getPayCounteract().add(costPlanDomain.getPayLendBalance()));
                    //银行卡信息
                    costPlanDomain.setBankCompany(supCost.getBankCompany());
                    costPlanDomain.setBankName(supCost.getBankName());
                    costPlanDomain.setBankCard(supCost.getBankCard());
                    costPlanDomain.setBankCardUser(supCost.getBankCardUser());

                    costPlanDomain.setLendType(lendTypeCostTypeResult.getTypeNo());
                }
                //计划单号
                String planNo = getCostPlanService().createNo();
                while (createdPlanNos.contains(planNo)){
                    planNo = getCostPlanService().createNo();
                }
                createdPlanNos.add(planNo);
                costPlanDomain.setCostPlanNo(planNo);
                //太快了计划单号会重复
                Thread.sleep(100);
                //文件
                costPlanDomain.setFilePath(path);

                //费用类别/付款类别/收款类别
                BeanUtils.copyProperties(costTypeResult, costPlanDomain, "id");
                costPlanDomain.setTypeId(costTypeResult.getId());
                //加入list
                costPlanDomainList.add(costPlanDomain);
                //log.info(costPlanDomain.toString());

            }else{
                //付款，需要保存
                //AddItemReq
                AddItemReq itemReq = jsonObject.toJavaObject(AddItemReq.class);
                itemReq.setFilePath(path);
                itemReq.setTypeNo(costTypeResult.getTypeNo());
                costPlanDomain.setTypeName(null);
                costPlanDomain.setFilePath(null);
                Integer costPlanHash = (costPlanDomain.getCompanyValue() + costPlanDomain.getBankCard()
                        + costPlanDomain.getBankCompany() + costPlanDomain.getBankName()).hashCode();
                Map<CostPlanDomain,List<AddItemReq>> planItemMap = costPlanAndItemMap.get(costPlanHash);
                if(planItemMap == null){
                    //计划单号
                    String planNo = getCostPlanService().createNo();
                    while (createdPlanNos.contains(planNo)){
                        planNo = getCostPlanService().createNo();
                    }
                    createdPlanNos.add(planNo);
                    costPlanDomain.setCostPlanNo(planNo);
                    itemReq.setCostPlanNo(costPlanDomain.getCostPlanNo());
                    planItemMap = new HashMap<>();
                    planItemMap.put(costPlanDomain, new ArrayList<AddItemReq>() {
                        {
                            add(itemReq);
                        }
                    });
                    costPlanAndItemMap.put(costPlanHash,planItemMap);
                }
                else{
                    String currentCostPlanNo = planItemMap.keySet().stream().map(x -> x.getCostPlanNo()).findFirst().get();
                    itemReq.setCostPlanNo(currentCostPlanNo);
                    planItemMap.values().stream().findFirst().get().add(itemReq);
                }
            }
        }
        if(costPlanAndItemMap.size() > 0){
            costPlanAndItemMap.values().forEach(x ->{
                x.entrySet().forEach(y -> {
                    y.getValue().forEach(v ->{

                    });
                    y.getValue().forEach(throwingConsumerWrapper(v ->{
                        AddItemResp resp = getCostPlanTempService().doSave(v);
                        if (!resp.getSuccess()){
                            throw new Exception("保存item异常");
                        }
                    }));
                    BigDecimal totalAmount = y.getValue().stream().map(AddItemReq::getAmount).reduce(BigDecimal::add).get();
                    y.getKey().setPlanAmount(totalAmount);
                    costPlanDomainList.add(y.getKey());
                });
            });
        }
        switch (sheetName){
            case "付款":
                costPlanDomainList.forEach(x -> {x.setCostForm(1);x.setCostTemplateId(3);});
                costPlanServiceListMap.put(SpringContextUtil.getBean(CostPlanNewPayServiceImpl.class),costPlanDomainList);
                break;
            case "收款":
                costPlanDomainList.forEach(x -> {x.setCostForm(2);x.setCostTemplateId(5);});
                costPlanServiceListMap.put(SpringContextUtil.getBean(CostPlanNewReceiptServiceImpl.class),costPlanDomainList);
                break;
            case "借支":
                costPlanDomainList.forEach(x -> {
                    x.setCostForm(3);
                    x.setIsLend(1);
                    x.setCostTemplateId(6);
                });
                costPlanServiceListMap.put(SpringContextUtil.getBean(CostPlanNewLend1ServiceImpl.class),costPlanDomainList);
                break;
            case "借还":
                costPlanDomainList.forEach(x -> {
                    x.setCostForm(3);
                    x.setIsLend(2);
                    x.setCostTemplateId(7);
                });
                costPlanServiceListMap.put(SpringContextUtil.getBean(CostPlanNewLend2ServiceImpl.class),costPlanDomainList);
                break;
        }
        return costPlanServiceListMap;
    }

    private static CostTypeResult getCostType(String sheetName,String typeName) throws Exception {
        Integer feeType = 0;
        switch (sheetName) {
            case "付款":
            case "借还":
                feeType = FEE_TYPE;
                break;
            case "收款":
                feeType = INCOME_TYPE;
                break;
            case "借支":
                feeType = BORROW;
                break;
        }
        List<CostTypeResult> costTypeResultList = getCostTypeService().queryByTypeName(typeName, feeType);
        if (costTypeResultList == null || costTypeResultList.size() <= 0 || costTypeResultList.size() > 1) {
            throw new Exception("费用类型【" + typeName + "】异常");
        }
        CostTypeResult costTypeResult = costTypeResultList.get(0);
        return costTypeResult;
    }
}


