package com.blt.other.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.auth.dao.CostReviewerMapper;
import com.blt.other.auth.dao.OaDepartmentMapper;
import com.blt.other.auth.dao.OaUserMapper;
import com.blt.other.auth.model.OaUser;
import com.blt.other.auth.service.IOaCompanyService;
import com.blt.other.auth.service.IOaDepartmentService;
import com.google.common.collect.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/13 5:33 下午
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("test")
public class OaDepartmentServiceImplTest {

    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    IOaDepartmentService oaDepartmentService;
    @Resource
    IOaCompanyService oaCompanyService;

    @Test
    public void initDepartment() {
        oaDepartmentMapper.selectList(new LambdaQueryWrapper<>())
                .forEach(oaDepartment -> {
                    OaUser oaUser = oaUserMapper.selectByUserName(oaDepartment.getManageUser1());


                    try {
                        oaDepartmentService.modifyFinancialReviewer(0, oaDepartment.getDepartmentId(), Lists.newArrayList(oaUser.getOaUserId()));
                    } catch (Exception ignore) {

                    }
                    oaDepartment.setCreateUserId(0);
                    oaDepartment.setCreateUserName("sys");
                });

        oaCompanyService.list(new LambdaQueryWrapper<>()).forEach(oaCompany -> {
            if (oaCompany.getName().contains("四千里") ||
                    oaCompany.getName().contains("4k") ||
                    oaCompany.getName().contains("歌戈儿") ||
                    oaCompany.getName().contains("迪致") ||
                    oaCompany.getName().contains("快询")){

            }
        });

    }
}
