package com.blt.other.entrepot.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.entrepot.service.InventoryLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@RequestMapping("inventory/log")
public class InventoryLogController {

    @Autowired
    private InventoryLogService inventoryLogService;

    @PostMapping("/getInventoryLogs")
    public Map<String,Object> getInventoryLogs(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String inventoryNo = request.getParameter("inventoryNo");
        String pageNumStr = request.getParameter("pageNum");
        Integer pageNum = Integer.parseInt(pageNumStr);
        String pageSizeStr = request.getParameter("pageSize");
        Integer pageSize = Integer.parseInt(pageSizeStr);
        Map<String, Object> inventoryLogsByInventoryNo = inventoryLogService.getInventoryLogsByInventoryNo(inventoryNo,pageNum,pageSize);

        inventoryLogsByInventoryNo.put("success",true);
        inventoryLogsByInventoryNo.put("msg","");

        return inventoryLogsByInventoryNo;
    }
}
