package com.blt.other.cost.service.impl;

import com.blt.other.cost.dao.CostDetailDao;
import com.blt.other.cost.service.CostDetailService;
import com.blt.other.database.model.CostDetailDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CostDetailServiceImpl implements CostDetailService {

    @Autowired
    private CostDetailDao costDetailDao;

    @Override
    public List<CostDetailDomain> getCostDetailListByCostNo(String costNo) {

        List<CostDetailDomain> list = costDetailDao.selectListByCostNo(costNo);
        return list;
    }

    @Override
    public CostDetailDomain getCostDetailByDetailNo(String detailNo) {
        return costDetailDao.selectByDetailNo(detailNo);
    }

    @Override
    public void deleteFilePath(String detailNo) {
        costDetailDao.deletedFilePath(detailNo);
    }

    @Override
    public CostDetailDomain getByCostNoAndKindNo(CostDetailDomain domain) {
        return costDetailDao.selectListByCostNoAndKindNo(domain);
    }

    @Override
    public Integer update(CostDetailDomain domain) {
        return costDetailDao.update(domain);
    }
}
