package com.blt.other.cost.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.cost.dto.CostTemplateApiDto;
import com.blt.other.cost.model.CostTemplate;

import java.util.List;

/**
 * <p>
 * 费用单模版 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
public interface ICostTemplateService extends IService<CostTemplate> {

    /**
     * <p>
     * 添加费用单模板
     * </p>
     *
     * @param costTemplate 费用单模板
     */
    void add(CostTemplate costTemplate);

    /**
     * <p>
     * 查询费用单模板
     * </p>
     *
     * @param id id
     * @return 费用单模板详情
     */
    CostTemplate queryDetail(Integer id);

    /**
     * <p>
     * 更新费用单模版
     * </p>
     *
     * @param costTemplate param
     */
    void edit(CostTemplate costTemplate);

    /**
     * <p>
     * 删除费用单模版
     * </p>
     *
     * @param id
     */
    void delete(Integer id);

    /**
     * <p>
     * 查询费用单模版
     * </p>
     *
     * @param req req
     * @return
     */
    List<CostTemplate> queryList(CostTemplateApiDto.QueryListReq req);
}
