package com.blt.other.cost.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 费用单模版
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostTemplate对象", description = "费用单模版")
public class CostTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "费用单模版名")
    private String templateName;

    @ApiModelProperty("是否开启自动审核")
    private Boolean enableAutoReview;

    @ApiModelProperty("是否开启部门审核")
    private Boolean enableDepartmentReview;

    @ApiModelProperty("是否开启财务自动审核")
    private Boolean enableFinancialAutoReview;

    @ApiModelProperty("是否开启最终人审核")
    private Boolean enableFinalReview;

    @ApiModelProperty("最终审核人最低审核金额")
    private Boolean finalMinimumReviewAmount;


    private Integer createUserId;
    private String createUserName;
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime lastUpdateTime;
    private Integer updateUserId;
    private String updateUserName;

    @TableField(exist = false)
    private List<CostTemplateCol> costTemplateColList;


}
