package com.blt.other.cost.controller.costplan;

import com.blt.other.cost.dto.CostPlanTempApiDto;
import com.blt.other.cost.service.CostPlanTempService;
import com.blt.other.database.model.CostPlanTempDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.math.BigDecimal;

@Api(tags = "费用计划子项接口")
@RestController
@RequestMapping("/cost/plan/temp")
@Slf4j
public class CostPlanTempController {
    @Autowired
    private CostPlanTempService costPlanTempService;

    @ApiOperation("保存无附件费用计划子项")
    @PostMapping(value = {"/addItem/noFile", "/addItem/file"})
    public CostPlanTempApiDto.AddItemResp addItem(CostPlanTempApiDto.AddItemReq req) {
        try {
            return costPlanTempService.doSave(req);
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            CostPlanTempApiDto.AddItemResp resp = new CostPlanTempApiDto.AddItemResp();
            resp.setSuccess(false);
            resp.setMsg(ex.getMessage());
            return resp;
        }
    }

    @ApiOperation("获取费用计划编号对应的费用计划子项")
    @GetMapping("/getCostTempByPlanNo")
    public CostPlanTempApiDto.GetCostTempByPlanNoResp getCostTempByPlanNo(@RequestParam String costPlanNo) {
        return costPlanTempService.getTempListByPlanNo(costPlanNo);
    }

    @ApiOperation("删除费用计划子项")
    @PostMapping("/deleteItem")
    public CostPlanTempApiDto.DeleteItemResp deleteItem(@RequestParam String costPlanNo,
                                                        @RequestParam String tempNo) {


        BigDecimal planAmount = costPlanTempService.deleteItemByPlanNoAndTempNo(costPlanNo, tempNo);
        CostPlanTempApiDto.DeleteItemResp resp = new CostPlanTempApiDto.DeleteItemResp();
        resp.setSuccess(true);
        resp.setMsg("success");
        resp.setPlanAmount(planAmount);
        return resp;
    }

    @ApiOperation("根据费用计划模板编号获取费用计划模版")
    @GetMapping("/getByTempNo")
    public CostPlanTempApiDto.GetByTempNoResp getByTempNo(@RequestParam String tempNo) {
        CostPlanTempDomain domain = costPlanTempService.getByTempNo(tempNo);
        CostPlanTempApiDto.GetByTempNoResp resp = new CostPlanTempApiDto.GetByTempNoResp();
        resp.setTmp(domain.castToDto());
        return resp;
    }

    @ApiOperation("更新费用项")
    @PostMapping(value = {"/resetItem/noFile", "/resetItem/file"})
    public CostPlanTempApiDto.ResetItemResp resetNoFile(CostPlanTempApiDto.ResetItemReq req) {

        CostPlanTempDomain tmp = costPlanTempService.resetItem(req);
        CostPlanTempApiDto.ResetItemResp resp = new CostPlanTempApiDto.ResetItemResp();
        resp.setSuccess(true);
        resp.setTmp(tmp);
        return resp;
    }


    @ApiOperation("下载费用单项附件")
    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(@RequestParam String tempNo) throws IOException {

        CostPlanTempDomain temp = costPlanTempService.getByTempNo(tempNo);
        String filePath = temp.getFilePath();
        String fileName = null;

        if (null != filePath) {
            String[] split = filePath.split("&");
            if (split.length >= 1) {
                fileName = split[split.length - 1];
            }
        }

        assert filePath != null;
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

}
