package com.blt.other.cost.controller;

import com.bailuntec.cost.api.dto.CostTypeDto;
import com.bailuntec.cost.api.dto.CostTypeKindDto;
import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.cost.service.CostCompanyService;
import com.blt.other.cost.service.CostTypeKindService;
import com.blt.other.cost.service.CostTypeService;
import com.blt.other.database.model.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "费用类型接口")
@RestController
@RequestMapping("cost/type")
public class CostTypeController {
    private static Logger logger = LoggerFactory.getLogger(CostTypeController.class);

    @Autowired
    private CostCompanyService costCompanyService;

    @Autowired
    private CostTypeKindService costTypeKindService;

    @Autowired
    private CostTypeService costTypeService;
    //物流科目编号
    @Value("${costTypeKind.logisticsSubjectCode}")
    private String logisticsSubjectCode;


    @ApiOperation("查询所有财务付款主体")
    @GetMapping("/getAllCompany")
    public List<CostCompanyDomain> getAllCompany() {
        return costCompanyService.getAllCompany();
    }

    @ApiOperation("获取所有财务付款主体权限？")
    @GetMapping("/getAllCompanyAuthority")
    public List<CostCompanyDomain> getAllCompanyAuthority() {
        return costCompanyService.getAllCompanyAuthority();
    }

    @ApiOperation("同步财务付款主体")
    @GetMapping("/syncAllCompany")
    public Map<String, Object> syncAllCompany(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        try {
            String syncResult = costCompanyService.syncCompany();
            String msg = "从财务系统同步公司主体数据，" + syncResult;
            result.put("success", true);
            result.put("msg", msg);
        } catch (Exception e) {
            logger.error(">>>>>从财务系统同步公司主体数据出错" + e.getMessage());
            result.put("success", false);
        }
        return result;
    }

    @ApiOperation("获取所有付款大类")
    @GetMapping("/getAllType")
    public List<CostTypeDomain> getAllType() {
        return costTypeService.getAllType();
    }

    @ApiOperation("添加付款大类")
    @PostMapping("/postNewType")
    public Map<String, Object> postNewType(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        Map<String, Object> result = new HashMap<>();

        String companyNo = request.getParameter("companyNo");
        String typeName = request.getParameter("typeName");
        String subjectCode = request.getParameter("subjectCode");
        boolean ismanage = Boolean.parseBoolean(request.getParameter("ismanage"));
        if (ismanage) {
            TypeRelationDomain typeRelationDomain = costTypeService.getTyeRelation(typeName);
            if (typeRelationDomain == null) {
                costTypeService.insertTypeRalation(typeName);
            }
        }


        CostTypeDomain costTypeDomain = new CostTypeDomain();
        costTypeDomain.setCompanyNo(companyNo);
        costTypeDomain.setTypeName(typeName);
        costTypeDomain.setSubjectCode(subjectCode);


        Integer integer = costTypeService.saveNewType(costTypeDomain);
        if (null != integer && integer >= 1) {
            result.put("success", true);
            result.put("msg", "费用类型保存成功");
            logger.warn("费用类型保存成功：" + companyNo + "   " + typeName);
        } else {
            result.put("success", false);
            result.put("msg", "费用类型已存在");
        }
        return result;
    }

    @ApiOperation("根据公司名获取费用大类")
    @GetMapping("/getTypeByCompanyNo")
    public List<CostTypeDto> getTypeByCompanyNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String companyNo = request.getParameter("companyNo");
        List<CostTypeDto> list;
        if ("allCompany".equals(companyNo)) {
            list = null;
        } else {
            list = costTypeService.getListByCompanyNo(companyNo);
        }
        return list;
    }

    @ApiOperation("获取费用小类")
    @GetMapping("/getAllCostKind")
    public Map<String, Object> getAllCostKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String pageNumStr = request.getParameter("pageNum");
        Integer pageNum = Integer.parseInt(pageNumStr);
        String pageSizeStr = request.getParameter("pageSize");
        Integer pageSize = Integer.parseInt(pageSizeStr);

        Map<String, Object> allKindWithPage = costTypeKindService.getAllKindWithPage(pageNum, pageSize);
        allKindWithPage.put("success", true);
        allKindWithPage.put("msg", "");
        return allKindWithPage;
    }


    @ApiOperation("根据 费用大类编号 获取费用小类")
    @GetMapping("/getKindByTypeNo")
    public List<CostTypeKindDto> getKindByTypeNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String typeNo = request.getParameter("typeNo");
        List<CostTypeKindDto> kindsByTypeNo;
        if ("isLendType".equals(typeNo)) {
            kindsByTypeNo = new ArrayList<>();
            CostTypeKindDto isLend1 = new CostTypeKindDto();
            isLend1.setId(-1);
            isLend1.setKindNo("1");
            isLend1.setKindName("借支");
            CostTypeKindDto isLend2 = new CostTypeKindDto();
            isLend2.setId(-2);
            isLend2.setKindNo("2");
            isLend2.setKindName("借还");

            kindsByTypeNo.add(isLend1);
            kindsByTypeNo.add(isLend2);
            return kindsByTypeNo;
        }

        if ("allType".equals(typeNo)) {
            String companyNo = request.getParameter("companyNo");
            if ("allCompany".equals(companyNo)) {
                kindsByTypeNo = costTypeKindService.getAllKind();
            } else {
                kindsByTypeNo = costTypeKindService.getListByCompanyNo(companyNo);
            }
        } else {
            kindsByTypeNo = costTypeKindService.getListByTypeNo(typeNo);
        }
        return kindsByTypeNo;
    }

    @ApiOperation("根据 公司自编no 获取费用小类")
    @GetMapping("/getKindsByCompanyNo")
    public List<CostTypeKindDto> getKindsByCompanyNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String companyNo = request.getParameter("companyNo");
        List<CostTypeKindDto> kindsByCompanyNo;
        if ("allCompany".equals(companyNo)) {
            kindsByCompanyNo = costTypeKindService.getAllKind();
            return kindsByCompanyNo;
        }
        kindsByCompanyNo = costTypeKindService.getListByCompanyNo(companyNo);
        return kindsByCompanyNo;
    }


    @GetMapping("/getKindByKindNo")
    public CostTypeKindDomain getKindByKindNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String kindNo = request.getParameter("kindNo");
        return costTypeKindService.getKindByKindNo(kindNo);
    }


    @ApiOperation("根据 费用小类no 获取费用小类")
    @PostMapping("/postNewKind")
    public Map<String, Object> postNewKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        String typeNo = request.getParameter("typeNo");
        String kindName = request.getParameter("kindName");
        String createUsername = request.getParameter("createUsername");
        String createUsercode = request.getParameter("createUsercode");

        CostTypeKindDomain costTypeKindDomain = new CostTypeKindDomain();
        costTypeKindDomain.setTypeNo(typeNo);
        costTypeKindDomain.setKindName(kindName);
        costTypeKindDomain.setCreateUsername(createUsername);
        costTypeKindDomain.setCreateUsercode(createUsercode);

        Integer integer = costTypeKindService.saveNewKind(costTypeKindDomain);
        Map<String, Object> result = new HashMap<>();
        if (null != integer && integer >= 1) {
            result.put("success", true);
            result.put("msg", "费用种类保存成功");
            logger.warn("费用种类保存成功：" + typeNo + "   " + kindName);
        } else {
            result.put("success", false);
            result.put("msg", "费用种类已存在");
        }
        return result;
    }

    @ApiOperation("获取所有费用小类")
    @GetMapping("/getAllKind")
    public List<CostTypeKindDto> getAllKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return costTypeKindService.getAllKind();
    }


    @ApiOperation("导入 excel 文件")
    @PostMapping("/import")
    public Map<String, Object> upload(@RequestParam("file") MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String fileName = file.getOriginalFilename();
        String createUsercode = request.getParameter("createUsercode");
        if (null == createUsercode || createUsercode.isEmpty()) {
            result.put("success", false);
            result.put("fileName", "请登陆");
            return result;
        }

        assert fileName != null;
        if (!fileName.matches("^.+\\.(?i)(xls)$") && !fileName.matches("^.+\\.(?i)(xlsx)$")) {
            result.put("success", false);
            result.put("msg", "上传文件格式不正确");
            return result;
        } else {
            try {
                Boolean importResult = costTypeKindService.importByExcel(file, createUsercode);
                if (!importResult) {
                    result.put("success", false);
                    result.put("fileName", "导入失败");
                    return result;
                }
            } catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
                e.printStackTrace();
                return result;
            }
        }
        result.put("success", true);
        result.put("fileName", fileName);
        return result;
    }

    @ApiOperation("编辑费用小类")
    @PostMapping("/editKind")
    public Map<String, Object> editKind(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String kindNo = request.getParameter("kindNo");
        String typeNo = request.getParameter("typeNo");
        String kindName = request.getParameter("kindName");
        if (null == typeNo || typeNo.isEmpty()) {
            result.put("success", false);
            result.put("msg", "请选择费用大类");
            return result;
        }
        CostTypeKindDomain costTypeKindDomain = new CostTypeKindDomain();
        costTypeKindDomain.setKindNo(kindNo);
        costTypeKindDomain.setKindName(kindName);
        costTypeKindDomain.setTypeNo(typeNo);

        Integer i = costTypeKindService.update(costTypeKindDomain);
        if (null != i && i >= 1) {
            result.put("success", true);
            result.put("msg", "费用小类已修改");
        }
        return result;
    }

    @ApiOperation("删除费用小类")
    @PostMapping("/deleteKind")
    public Map<String, Object> deleteKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String kindNo = request.getParameter("kindNo");
        Integer i = costTypeKindService.deleteKind(kindNo);
        if (null != i && i >= 1) {
            result.put("success", true);
            result.put("msg", "已删除");
        } else {
            result.put("success", false);
        }
        return result;
    }


    @ApiOperation("获取物流subjectCode")
    @GetMapping("/getLogisticsCode")
    public Map<String, Object> getLogisticsCode(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        if (logisticsSubjectCode != null && logisticsSubjectCode.length() > 0) {
            result.put("success", true);
            result.put("logisticsCode", logisticsSubjectCode);
        } else {
            result.put("success", false);
        }
        return result;
    }

    @ApiOperation("获取物流银行帐号")
    @PostMapping("/getLogisticsBank")
    public Map<String, Object> getLogisticsBank(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String subSupplierName = request.getParameter("subSupplierName");
        LogisticsSupplierBankDomain bankDomain = costTypeKindService.getLogisticsBank(subSupplierName);
        if (bankDomain != null) {
            result.put("success", true);
            result.put("bankInfo", bankDomain);
        } else {
            result.put("success", false);
        }
        return result;
    }
}
