package com.blt.other.auth.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-10-13
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="CostReviewer对象", description="")
public class CostReviewer implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final Integer departmentReviewer=1;
    public static final Integer financialReviewer =2;
    public static final Integer finalReviewer =3;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "type=1:部门id ; type in (2,3):财务主体id;")
    private Integer referId;

    @ApiModelProperty(value = "1-部门审核人 2-财务审核人 3-最终审核人")
    private Integer type;

    @ApiModelProperty(value = "审核人")
    private Integer reviewerUserId;

    @ApiModelProperty(value = "审核人姓名")
    private String reviewerUserName;


}
