package com.blt.other.module.auth.dto.response;

import com.baomidou.mybatisplus.annotation.TableField;
import com.blt.other.module.auth.model.CostReviewer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/21 9:38 上午
 */
@Data
public class DepartmentReviewerListItem {

    private Integer id;

    @ApiModelProperty(value = "oa部门id")
    private Integer departmentId;

    @ApiModelProperty(value = "oa部门编码")
    private String code;

    @ApiModelProperty(value = "oa公司主体id")
    private Integer companyId;

    @TableField(exist = false)
    private String companyName;

    private String manageUser1;

    private String manageUser2;

    private Integer parentId;

    @ApiModelProperty(value = "部门名称")
    private String name;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    private BigDecimal departmentMinimumReviewAmount;

    @ApiModelProperty(value = "创建人id")
    private Integer createUserId;
    @ApiModelProperty(value = "创建人姓名")
    private String createUserName;


    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime createTime;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty("更新用户id")
    private Integer updateUserId;
    @ApiModelProperty("更新用户姓名")
    private String updateUserName;

    @TableField(exist = false)
    private List<CostReviewer> costReviewerList;

}
