package com.blt.other.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.common.base.SysUser;
import com.blt.other.common.exception.BizRuntimeException;
import lombok.extern.slf4j.Slf4j;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

import java.util.HashMap;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/18 11:47 上午
 */
@Slf4j
public class JwtUtil {

    /**
     * 前缀
     */
    public static final String TOKEN_PREFIX = "Bearer ";
    private static final String PUBLIC_KEY = "{\"kty\":\"RSA\",\"use\":\"sig\",\"kid\":\"1f86f9a4a708e507a9285728d32f3bc1\",\"e\":\"AQAB\",\"n\":\"xu23WtxFwR5cjiQPXU12F4nH-4UvBWKraA5mUF7qjKf8xekZ1XY6KdrVwAEgyL-ZovK-xVGkqcRrs3zhUazB05EwUlG3BfdcGMWsE4WhVPcNLx8FWcbzSa5PfurUhB-hPksDw-Nrrm78EV85hhvPf9v395gTfb-9AcJ2yTYC8XTHHMIe6BPegmwFQ08W3uzhfbtiJuO6ry-0MofnYEZ8yyjn5AupbLgFZ2FGloBNznaTfNJwLAIONSIbSTN-vrqRYntqzlASdU4fwuQ7M7Kqo58NxI47Ev3UO3qDHLwG6bcTT8OSEsW10PWJgTGdz2-p5_74vNTfPwYcSaJpB73tyQ\",\"alg\":\"RS256\"}";

    /**
     * 功能描述: 解密Bailun Sso Token
     *
     * @param token jwtToken
     */
    public static SysUser validateToken(String token) {
        try {
            JwtConsumer consumer = new JwtConsumerBuilder()
                    .setExpectedAudience("http://localhost:5001/resources", "bailunApi")
                    .setVerificationKey(new RsaJsonWebKey(JSON.parseObject(PUBLIC_KEY, new TypeReference<HashMap<String, Object>>() {
                    })).getPublicKey())
                    .build();
            JwtClaims claims = consumer.processToClaims(token.replaceAll(TOKEN_PREFIX, ""));
            if (claims != null) {
                log.debug("认证通过：user:{}", claims.toJson());

                return JsonUtilByFsJson.jsonToBean(claims.toJson(), SysUser.class);
            }
            throw new BizRuntimeException("400", "登陆失效");
        } catch (Exception e) {
            e.printStackTrace();
            throw new BizRuntimeException("400", "登陆失效");
        }
    }


}
