package com.blt.other.module.cost.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
@ApiModel("审批历史查询Vo")
public class ApprovalHistoryVo {

    @ApiModelProperty
    private Integer id;

    @ApiModelProperty(value = "费用单号")
    private String costNo;

    @ApiModelProperty(value = "费用类型")
    private String costFrom;

    @ApiModelProperty(value = "借支/借还")
    private Integer isLend;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "审批时间")
    private LocalDateTime approvalTime;

    @ApiModelProperty(value = "审批前费用状态")
    private String costStatus;

    @ApiModelProperty(value = "是否通过")
    private boolean isPassed;

    @ApiModelProperty(value = "审批人")
    private String username;

    @ApiModelProperty("费用类型")
    private String typeName;
}
