package com.blt.other.module.cost.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.ApprovalHistoryReq;
import com.blt.other.module.cost.dto.response.ApprovalHistoryResult;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.cost.vo.ApprovalHistoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Api(tags = "审批历史")
@RestController
@RequestMapping("/cost/approval/history")
public class ApprovalHistoryController {

    @Resource
    ApprovalHistoryService approvalHistoryService;

    @ApiOperation("获取审批历史列表")
    @GetMapping
    public Page<ApprovalHistoryVo> get(ApprovalHistoryReq req) {
        return approvalHistoryService.getApprovalHistoryList(req);
    }
}
