package com.blt.other.database.model;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class BuyPlanDomain {
    private Integer id;
    // + 采购计划单号
    private String no;
    // + 状态:0#待提交;1#待主管审核;2#主管审核通过;3#作废 4 审核驳回;
    private Integer status;
    // 采购日期
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date purday;
    // 接收货物仓库code
    private String warehouseid;
    // 接收货物仓库名称( 采购主体 )
    private String warehousename;
    // 部门id
    private Integer departmentid;
    // 部门名称
    private String departmentname;
    // DEFAULT '[]' 对应采购单号[1,2]
    private String purids;
    // 计划单总金额
    private BigDecimal amount;
    // 计划单商品总数量
    private Integer count;
    // 是否紧急:0#非紧急;1#紧急
    private Integer isurgency;
    // 是否删除:0#否;1#已删除
    private Integer isdelete;
    // 采购计划备注
    private String remark;
    // 附件id
    private Integer fileid;
    // 附件保存路径
    private String filepath;
    // 导入的计划采购单id
    private Integer dataid;
    // 排序，用于标识当天订单索引（当天第几单）
    private Integer sort;
    // 提交审核时间 DEFAULT '1999-01-01 00:00:00'
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date submittime;
    // + 审核状态:0#不审核;1#待审核;2#审核通过;3#审核驳回
    private Integer auditstatus;
    // 审核人id
    private Integer audituserid;
    // 审核人名称
    private String auditusername;
    // 审核时间
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date audittime;
    // 审核备注
    private String auditremark;
    // 创建人
    private Integer createuserid;
    // + 创建人名称
    private String createusername;
    // 创建时间
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date createtime;
    // 最后操作人id
    private Integer modifyuserid;
    // 最后操作人名称
    private String modifyusername;
    // 最后操作时间
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date modifytime;
    // 主体
    private String company;

    private String rejectReason; // 主管审核驳回原因

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNo() {
        return no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getPurday() {
        return purday;
    }

    public void setPurday(Date purday) {
        this.purday = purday;
    }

    public String getWarehouseid() {
        return warehouseid;
    }

    public void setWarehouseid(String warehouseid) {
        this.warehouseid = warehouseid;
    }

    public String getWarehousename() {
        return warehousename;
    }

    public void setWarehousename(String warehousename) {
        this.warehousename = warehousename;
    }

    public Integer getDepartmentid() {
        return departmentid;
    }

    public void setDepartmentid(Integer departmentid) {
        this.departmentid = departmentid;
    }

    public String getDepartmentname() {
        return departmentname;
    }

    public void setDepartmentname(String departmentname) {
        this.departmentname = departmentname;
    }

    public String getPurids() {
        return purids;
    }

    public void setPurids(String purids) {
        this.purids = purids;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getIsurgency() {
        return isurgency;
    }

    public void setIsurgency(Integer isurgency) {
        this.isurgency = isurgency;
    }

    public Integer getIsdelete() {
        return isdelete;
    }

    public void setIsdelete(Integer isdelete) {
        this.isdelete = isdelete;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getFileid() {
        return fileid;
    }

    public void setFileid(Integer fileid) {
        this.fileid = fileid;
    }

    public String getFilepath() {
        return filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public Integer getDataid() {
        return dataid;
    }

    public void setDataid(Integer dataid) {
        this.dataid = dataid;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Date getSubmittime() {
        return submittime;
    }

    public void setSubmittime(Date submittime) {
        this.submittime = submittime;
    }

    public Integer getAuditstatus() {
        return auditstatus;
    }

    public void setAuditstatus(Integer auditstatus) {
        this.auditstatus = auditstatus;
    }

    public Integer getAudituserid() {
        return audituserid;
    }

    public void setAudituserid(Integer audituserid) {
        this.audituserid = audituserid;
    }

    public String getAuditusername() {
        return auditusername;
    }

    public void setAuditusername(String auditusername) {
        this.auditusername = auditusername;
    }

    public Date getAudittime() {
        return audittime;
    }

    public void setAudittime(Date audittime) {
        this.audittime = audittime;
    }

    public String getAuditremark() {
        return auditremark;
    }

    public void setAuditremark(String auditremark) {
        this.auditremark = auditremark;
    }

    public Integer getCreateuserid() {
        return createuserid;
    }

    public void setCreateuserid(Integer createuserid) {
        this.createuserid = createuserid;
    }

    public String getCreateusername() {
        return createusername;
    }

    public void setCreateusername(String createusername) {
        this.createusername = createusername;
    }

    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public Integer getModifyuserid() {
        return modifyuserid;
    }

    public void setModifyuserid(Integer modifyuserid) {
        this.modifyuserid = modifyuserid;
    }

    public String getModifyusername() {
        return modifyusername;
    }

    public void setModifyusername(String modifyusername) {
        this.modifyusername = modifyusername;
    }

    public Date getModifytime() {
        return modifytime;
    }

    public void setModifytime(Date modifytime) {
        this.modifytime = modifytime;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    @Override
    public String toString() {
        return "BuyPlanDomain{" +
                "id=" + id +
                ", no='" + no + '\'' +
                ", status=" + status +
                ", purday=" + purday +
                ", warehouseid='" + warehouseid + '\'' +
                ", warehousename='" + warehousename + '\'' +
                ", departmentid=" + departmentid +
                ", departmentname='" + departmentname + '\'' +
                ", purids='" + purids + '\'' +
                ", amount=" + amount +
                ", count=" + count +
                ", isurgency=" + isurgency +
                ", isdelete=" + isdelete +
                ", remark='" + remark + '\'' +
                ", fileid=" + fileid +
                ", filepath='" + filepath + '\'' +
                ", dataid=" + dataid +
                ", sort=" + sort +
                ", submittime=" + submittime +
                ", auditstatus=" + auditstatus +
                ", audituserid=" + audituserid +
                ", auditusername='" + auditusername + '\'' +
                ", audittime=" + audittime +
                ", auditremark='" + auditremark + '\'' +
                ", createuserid=" + createuserid +
                ", createusername='" + createusername + '\'' +
                ", createtime=" + createtime +
                ", modifyuserid=" + modifyuserid +
                ", modifyusername='" + modifyusername + '\'' +
                ", modifytime=" + modifytime +
                ", company='" + company + '\'' +
                ", rejectReason='" + rejectReason + '\'' +
                '}';
    }
}
