package com.blt.other.module.sys.service;

import com.blt.other.module.auth.vo.UserGetByBLUserAcct;
import com.blt.other.database.model.UserDomain;
import org.springframework.lang.NonNull;

import java.util.List;

public interface UserService {

    UserDomain findOne(String usercode);

    List<UserDomain> findAllUser();

    Integer saveUser(UserGetByBLUserAcct userGetByBLUserAcct);

    UserDomain findByUserid(int parseInt);

    Integer updateUser(UserDomain user);

    void insertUser(UserDomain user);

    List<UserDomain> getListByKey(String key);

    List<UserDomain> getAllAdmins();

    List<UserDomain> getAllFinansys();

    Integer save(UserDomain user);

    Integer deleteUser(int parseInt);

    List<UserDomain> getAllSupAdmins();

    /**
     * <p>
     * 根据百伦一级部门id查找费用系统用户列表
     * </p>
     *
     * @param primaryDepartmentId 一级部门id
     * @return 费用系统用户列表
     */
    List<UserDomain> getByPrimaryDepartmentId(@NonNull Integer primaryDepartmentId);

    /**
     * <p>
     * 根据百伦公司id查找费用系统用户列表
     * </p>
     *
     * @param companyId 公司id
     * @return 费用系统用户列表
     */
    List<UserDomain> getByCompanyId(@NonNull Integer companyId);

}
