package com.blt.other.module.entrepot.service;

import com.blt.other.module.database.model.StorageDomain;
import com.blt.other.module.entrepot.dto.StorageDto;

import java.util.Map;

public interface StorageService {

    /**
     * 保存入库单
     * @param buyno
     * @return
     */
    Integer saveStorage(String buyno,String responseMsg);

    /**
     * 根据采购单保存入库单
     * @param buyno
     * @return
     */
    Integer saveStorageByBuy(String buyno);

    /**
     * 获取所有入库单
     * @return
     */
    Map<String,Object> getAllStorage(Integer pagesize, Integer page);

    /**
     * 通过 storageno 获取入库单
     * @param storageno
     * @return
     */
    StorageDto getStorageByStorageno(String storageno);

    /**
     * 修改入库单信息
     * @param storageDomain
     * @return
     */
    Integer update(StorageDomain storageDomain);

    /**
     * 根据
     * @param buyNo
     * @return
     */
    StorageDto getStorageByBuyNo(String buyNo);

    /**
     * 将从数据库获取的 StorageDomain 转为 view 层的 storageDto
     * @param storageDomain
     * @return
     */
    StorageDto storageDomainToDto(StorageDomain storageDomain);

}
