package com.blt.other.module.commons.service.impl;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Func;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.blt.other.database.model.BuyPlanDomain;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.module.commons.dao.IndexDao;
import com.blt.other.module.commons.service.IndexService;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostPlanDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import com.blt.other.module.purchasing.service.BuyPlanService;
import lombok.var;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.el.MethodNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class IndexServiceImpl implements IndexService {

    @Resource
    private IndexDao indexDao;
    @Resource
    private BuyPlanService buyPlanService;
    @Resource
    private CostDao costDao;
    @Resource
    private CostPlanDao costPlanDao;

    @Override
    public List<BuyPlanDto> getBuyPlanList(Integer userid) {
        List<BuyPlanDomain> buyPlanDomains = indexDao.selectBuyPlanList(userid);
        return buyPlanService.getDtoList(buyPlanDomains);
    }

    @Override
    public List<CostPlanDto> getCostPlanList(Integer userid) {
        List<CostPlanDomain> costPlanDomains = indexDao.selectCostPlanList(userid);
        return costPlanDomains.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList());
    }

    @Override
    public List<CostPlanDto> getCostPlanList(Integer userid, Integer status, String condition, List<Integer> statusList,Integer limit) {
        LambdaQueryWrapper<CostPlanDomain> query = new LambdaQueryWrapper<CostPlanDomain>().eq(CostPlanDomain::getCreateUserid, userid);
        if (condition != null && !condition.isEmpty()) {
            try {
                SFunction<CostPlanDomain, Integer> getStatus = CostPlanDomain::getCostPlanStatus;
                if (statusList != null && !statusList.isEmpty() && (condition.equals("in") || condition.equals("notIn"))) {
                    query.getClass().getMethod(condition, Object.class, Collection.class)
                            .invoke(query, getStatus, statusList);
                } else if (status != null) {
                    query.getClass().getMethod(condition, Object.class, Object.class)
                            .invoke(query, getStatus, status);
                }
            } catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        query.orderByDesc(CostPlanDomain::getId);
        if (limit != null && limit > 0)
            query.last("limit " + limit);
        List<CostPlanDomain> costDomainList = costPlanDao.selectList(query);
        return costDomainList.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList());
    }

    @Override
    public List<CostDto> getCostList(Integer userid) {
        List<CostDomain> costDomains = indexDao.selectCostList(userid);
        //costDao.selectList(new LambdaQueryWrapper<CostDomain>().in(CostDomain::getCostNo,""));
        return costDomains.stream().map(CostDomain::castToDto).collect(Collectors.toList());
    }

    @Override
    public List<CostDto> getCostList(Integer userid, Integer status, String condition, List<Integer> statusList, Integer limit) {
        LambdaQueryWrapper<CostDomain> query = new LambdaQueryWrapper<CostDomain>().eq(CostDomain::getCreateUserid, userid);
        if (condition != null && !condition.isEmpty()) {
            try {
                SFunction<CostDomain, Integer> getCostStatus = CostDomain::getCostStatus;
                if (statusList != null && !statusList.isEmpty() && (condition.equals("in") || condition.equals("notIn"))) {
                    query.getClass().getMethod(condition, Object.class, Collection.class)
                            .invoke(query, getCostStatus, statusList);
                } else if (status != null) {
                    query.getClass().getMethod(condition, Object.class, Object.class)
                            .invoke(query, getCostStatus, status);
                }
            } catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        query.orderByDesc(CostDomain::getId);
        if (limit != null && limit > 0)
            query.last("limit " + limit);
        List<CostDomain> costDomainList = costDao.selectList(query);
        return costDomainList.stream().map(CostDomain::castToDto).collect(Collectors.toList());
    }

}
