package com.blt.other.common.config;

import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

import javax.servlet.MultipartConfigElement;

@Configuration
public class MultipartConfiguration {

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        //单个文件最大
        factory.setMaxFileSize(DataSize.of(80, DataUnit.MEGABYTES)); //KB,MB
        // 设置总上传数据总大小
        factory.setMaxRequestSize(DataSize.of(102400, DataUnit.KILOBYTES));
        return factory.createMultipartConfig();
    }
}
