package com.blt.other.module.cost.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;


@Data
public class CostCheckSearchKeysVo {
    private Params params;

    @Data
    public static class Params {
        private Keys keys;
        private Integer pageNum;
        private Integer pageSize;

        @Data
        public static class Keys {
            private String authority;
            private Integer userId;
            private String companyNo;
            private Integer costForm;
            private String createUsercode;
            private Integer costStatus;
            private Integer lendStatus;
            private Integer isTax;
            private String linkCost;
            private Integer isLend;
            @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
            private Date beginPayTime;
            @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
            private Date endPayTime;
            private Integer logisticsSupplierId; // 一级物流供应商ID
            private Integer subLogisticsSupplierId; // 二级物流供应商ID

        }
    }
}
