package com.blt.other.common.rabbitmq.model;

import com.blt.other.common.rabbitmq.type.ExchangeTypeEnum;
import com.sun.istack.NotNull;
import lombok.Data;

import java.util.Map;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-04-28
 * @Modified by:
 */
@Data
public class MqExchange {
    /**
     * 默认的DIRECT类型的交换机
     */
    public static final String DEFAULT_DIRECT_EXCHANGE = "amq.direct";
    /**
     * 默认的TOPIC类型的交换机
     */
    public static final String DEFAULT_TOPIC_EXCHANGE = "amq.topic";
    /**
     * 默认的HEADERS类型的交换机
     */
    public static final String DEFAULT_HEADERS_EXCHANGE = "amq.headers";
    /**
     * 默认的FANOUT类型的交换机
     */
    public static final String DEFAULT_FANOUT_EXCHANGE = "amq.fanout";
    /**
     * 交换机的名称
     */
    @NotNull
    private String name;

    /**
     * 交换机的类型
     */
    @NotNull
    private ExchangeTypeEnum type;
    /**
     * 是否持久化
     * 持久化可以将交换机存盘，在服务器重启的时候不会丢失相关的信息
     * 默认是开启持久化
     */
    private boolean durable = Boolean.TRUE;
    /**
     * 是否自动删除
     * 自动删除的前提是至少有一个队列或者交换机与这个交互机绑定，之后所有与这个交换机绑定的队列或者交换机都与此解绑
     */
    private boolean autoDelete;

    public MqExchange name(String name) {
        this.name = name;
        return this;
    }


    public MqExchange type(ExchangeTypeEnum type) {
        this.type = type;
        return this;
    }

    public MqExchange durable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public MqExchange autoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public MqExchange arguments(Map<String, Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    /**
     * 自定义属性参数
     * 比如：alternate-exchange
     */
    private Map<String, Object> arguments;
}
